/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.field;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jeasy.batch.core.converter.TypeConverter;
import org.jeasy.batch.core.field.FieldExtractor;
import org.jeasy.batch.core.mapper.TypeConverterRegistrationException;
import org.jeasy.batch.core.util.Utils;

public class BeanFieldExtractor<P>
implements FieldExtractor<P> {
    private final String[] fields;
    private final Map<String, Method> getters;
    private final Map<Class<?>, TypeConverter<?, String>> typeConverters;

    public BeanFieldExtractor(Class<P> type, String ... fields) {
        try {
            this.getters = Utils.getGetters(type);
        }
        catch (IntrospectionException exception) {
            throw new IllegalArgumentException(exception);
        }
        this.fields = fields.length == 0 ? this.getters.keySet().toArray(new String[0]) : fields;
        this.typeConverters = new HashMap();
    }

    @Override
    public Iterable<Object> extractFields(P payload) throws Exception {
        Object[] values = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            Object value = this.getValue(this.fields[i], payload);
            values[i] = this.format(value);
        }
        return Arrays.asList(values);
    }

    protected Object getValue(String field, P object) throws InvocationTargetException, IllegalAccessException {
        return this.getters.get(field).invoke(object, new Object[0]);
    }

    private Object format(Object value) {
        if (value == null) {
            return null;
        }
        TypeConverter<?, String> typeConverter = this.typeConverters.get(value.getClass());
        if (typeConverter != null) {
            return typeConverter.convert(value);
        }
        return value;
    }

    public void registerTypeConverter(TypeConverter<?, String> typeConverter) {
        Class<?> clazz;
        try {
            clazz = Utils.getGenericTypeNameFromTypeConverter(typeConverter, 0);
        }
        catch (Exception e) {
            throw new TypeConverterRegistrationException("Unable to register custom type converter " + typeConverter.getClass().getName(), e);
        }
        this.typeConverters.put(clazz, typeConverter);
    }
}

