/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.job;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jeasy.batch.core.job.JobMetrics;
import org.jeasy.batch.core.job.JobParameters;
import org.jeasy.batch.core.job.JobReport;
import org.jeasy.batch.core.job.JobReportMerger;
import org.jeasy.batch.core.job.JobStatus;

public class DefaultJobReportMerger
implements JobReportMerger {
    @Override
    public JobReport mergerReports(JobReport ... jobReports) {
        ArrayList<LocalDateTime> startTimes = new ArrayList<LocalDateTime>();
        ArrayList<LocalDateTime> endTimes = new ArrayList<LocalDateTime>();
        ArrayList<String> jobNames = new ArrayList<String>();
        JobParameters parameters = new JobParameters();
        JobMetrics metrics = new JobMetrics();
        JobReport finalJobReport = new JobReport();
        finalJobReport.setParameters(parameters);
        finalJobReport.setMetrics(metrics);
        finalJobReport.setStatus(JobStatus.COMPLETED);
        for (JobReport jobReport : jobReports) {
            startTimes.add(jobReport.getMetrics().getStartTime());
            endTimes.add(jobReport.getMetrics().getEndTime());
            this.calculateReadRecords(finalJobReport, jobReport);
            this.calculateWrittenRecords(finalJobReport, jobReport);
            this.calculateFilteredRecords(finalJobReport, jobReport);
            this.calculateErrorRecords(finalJobReport, jobReport);
            this.setStatus(finalJobReport, jobReport);
            jobNames.add(jobReport.getJobName());
            finalJobReport.setSystemProperties(jobReport.getSystemProperties());
        }
        finalJobReport.getMetrics().setStartTime((LocalDateTime)Collections.min(startTimes));
        finalJobReport.getMetrics().setEndTime((LocalDateTime)Collections.max(endTimes));
        finalJobReport.setJobName(this.concatenate(jobNames));
        return finalJobReport;
    }

    private void setStatus(JobReport finalJobReport, JobReport jobReport) {
        if (JobStatus.FAILED.equals((Object)jobReport.getStatus())) {
            finalJobReport.setStatus(JobStatus.FAILED);
        }
    }

    private void calculateReadRecords(JobReport finalJobReport, JobReport jobReport) {
        finalJobReport.getMetrics().incrementReadCount(jobReport.getMetrics().getReadCount());
    }

    private void calculateWrittenRecords(JobReport finalJobReport, JobReport jobReport) {
        finalJobReport.getMetrics().incrementWriteCount(jobReport.getMetrics().getWriteCount());
    }

    private void calculateErrorRecords(JobReport finalJobReport, JobReport jobReport) {
        finalJobReport.getMetrics().incrementErrorCount(jobReport.getMetrics().getErrorCount());
    }

    private void calculateFilteredRecords(JobReport finalJobReport, JobReport jobReport) {
        finalJobReport.getMetrics().incrementFilterCount(jobReport.getMetrics().getFilterCount());
    }

    private String concatenate(List<String> names) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("|");
        }
        return stringBuilder.toString();
    }
}

