/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.job;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

public class JobMetrics
implements Serializable {
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private long readCount;
    private long writeCount;
    private long filterCount;
    private long errorCount;
    private Map<String, Object> customMetrics = new HashMap<String, Object>();

    public void incrementFilterCount() {
        ++this.filterCount;
    }

    public void incrementFilterCount(long count) {
        this.filterCount += count;
    }

    public void incrementErrorCount() {
        ++this.errorCount;
    }

    public void incrementErrorCount(long count) {
        this.errorCount += count;
    }

    public void incrementReadCount() {
        ++this.readCount;
    }

    public void incrementReadCount(long count) {
        this.readCount += count;
    }

    public void incrementWriteCount(long count) {
        this.writeCount += count;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public Duration getDuration() {
        if (this.getStartTime() != null && this.getEndTime() != null) {
            return Duration.between(this.getStartTime(), this.getEndTime());
        }
        return null;
    }

    public long getFilterCount() {
        return this.filterCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public long getReadCount() {
        return this.readCount;
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public void addMetric(String name, Object value) {
        this.customMetrics.put(name, value);
    }

    public Map<String, Object> getCustomMetrics() {
        return this.customMetrics;
    }
}

