/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jeasy.batch.core.job.JobParameters;
import org.jeasy.batch.core.job.JobReport;
import org.jeasy.batch.core.listener.JobListener;

public class CompositeJobListener
implements JobListener {
    private List<JobListener> listeners;

    public CompositeJobListener() {
        this(new ArrayList<JobListener>());
    }

    public CompositeJobListener(List<JobListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void beforeJob(JobParameters jobParameters) {
        for (JobListener listener : this.listeners) {
            listener.beforeJob(jobParameters);
        }
    }

    @Override
    public void afterJob(JobReport jobReport) {
        ListIterator<JobListener> iterator = this.listeners.listIterator(this.listeners.size());
        while (iterator.hasPrevious()) {
            iterator.previous().afterJob(jobReport);
        }
    }

    public void addJobListener(JobListener jobListener) {
        this.listeners.add(jobListener);
    }
}

