/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.processor;

import java.util.concurrent.Callable;
import org.jeasy.batch.core.processor.RecordProcessor;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.retry.RetryPolicy;
import org.jeasy.batch.core.retry.RetryTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableRecordProcessor<I, O>
implements RecordProcessor<I, O> {
    private RecordProcessor<I, O> delegate;
    private RecordProcessingTemplate recordProcessingTemplate;

    public RetryableRecordProcessor(RecordProcessor<I, O> delegate, RetryPolicy retryPolicy) {
        this.delegate = delegate;
        this.recordProcessingTemplate = new RecordProcessingTemplate(retryPolicy);
    }

    @Override
    public Record<O> processRecord(Record<I> record) throws Exception {
        return (Record)this.recordProcessingTemplate.execute(new RecordProcessingCallable<I, O>(this.delegate, record));
    }

    private static class RecordProcessingTemplate
    extends RetryTemplate {
        private final Logger LOGGER = LoggerFactory.getLogger((String)RecordProcessingTemplate.class.getName());

        RecordProcessingTemplate(RetryPolicy retryPolicy) {
            super(retryPolicy);
        }

        @Override
        protected void beforeCall() {
        }

        @Override
        protected void afterCall(Object result) {
        }

        @Override
        protected void onException(Exception e) {
            this.LOGGER.error("Unable to process record", (Throwable)e);
        }

        @Override
        protected void onMaxAttempts(Exception e) {
            this.LOGGER.error("Unable to process record after {} attempt(s)", (Object)this.retryPolicy.getMaxAttempts());
        }

        @Override
        protected void beforeWait() {
            this.LOGGER.debug("Waiting for {} {} before retrying to process record", (Object)this.retryPolicy.getDelay(), (Object)this.retryPolicy.getTimeUnit());
        }

        @Override
        protected void afterWait() {
        }
    }

    private static class RecordProcessingCallable<I, O>
    implements Callable<Record<O>> {
        private RecordProcessor<I, O> recordProcessor;
        private Record<I> record;

        RecordProcessingCallable(RecordProcessor<I, O> recordProcessor, Record<I> record) {
            this.recordProcessor = recordProcessor;
            this.record = record;
        }

        @Override
        public Record<O> call() throws Exception {
            return this.recordProcessor.processRecord(this.record);
        }
    }
}

