/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.reader;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.stream.Stream;
import org.jeasy.batch.core.reader.RecordReader;
import org.jeasy.batch.core.record.FileRecord;
import org.jeasy.batch.core.record.Header;
import org.jeasy.batch.core.util.Utils;

public class FileRecordReader
implements RecordReader<Path> {
    private Path directory;
    private Iterator<Path> iterator;
    private long currentRecordNumber;
    private boolean recursive;
    private Stream<Path> pathStream;

    public FileRecordReader(Path path) {
        this(path, false);
    }

    public FileRecordReader(Path path, boolean recursive) {
        Utils.checkNotNull(path, "path");
        this.directory = path;
        this.recursive = recursive;
    }

    @Override
    public void open() throws Exception {
        this.checkDirectory();
        this.pathStream = this.recursive ? Files.walk(this.directory, new FileVisitOption[0]) : Files.list(this.directory);
        this.iterator = this.pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).iterator();
        this.currentRecordNumber = 0L;
    }

    @Override
    public void close() throws Exception {
        if (this.pathStream != null) {
            this.pathStream.close();
        }
    }

    private void checkDirectory() {
        Utils.checkArgument(Files.exists(this.directory, new LinkOption[0]), String.format("Directory %s does not exist.", this.getDataSourceName()));
        Utils.checkArgument(Files.isDirectory(this.directory, new LinkOption[0]), String.format("%s is not a directory.", this.getDataSourceName()));
        Utils.checkArgument(Files.isReadable(this.directory), String.format("Unable to read files from directory %s. Permission denied.", this.getDataSourceName()));
    }

    public FileRecord readRecord() {
        Header header = new Header(++this.currentRecordNumber, this.getDataSourceName(), LocalDateTime.now());
        if (this.iterator.hasNext()) {
            return new FileRecord(header, this.iterator.next());
        }
        return null;
    }

    private String getDataSourceName() {
        return this.directory.toAbsolutePath().toString();
    }
}

