/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.reader;

import java.time.LocalDateTime;
import java.util.Scanner;
import org.jeasy.batch.core.reader.RecordReader;
import org.jeasy.batch.core.record.Header;
import org.jeasy.batch.core.record.StringRecord;

public class StandardInputRecordReader
implements RecordReader<String> {
    private static final String DEFAULT_TERMINATION_WORD = "quit";
    private Scanner scanner;
    private long recordNumber;
    private String terminationWord;

    public StandardInputRecordReader() {
        this(DEFAULT_TERMINATION_WORD);
    }

    public StandardInputRecordReader(String terminationWord) {
        this.terminationWord = terminationWord;
    }

    @Override
    public void open() {
        this.scanner = new Scanner(System.in);
    }

    public StringRecord readRecord() {
        boolean stop;
        String payload = this.scanner.nextLine();
        boolean bl = stop = payload != null && !payload.isEmpty() && payload.equalsIgnoreCase(this.terminationWord);
        if (stop) {
            return null;
        }
        Header header = new Header(++this.recordNumber, this.getDataSourceName(), LocalDateTime.now());
        return new StringRecord(header, payload);
    }

    private String getDataSourceName() {
        return "Standard Input";
    }

    @Override
    public void close() {
        this.scanner.close();
    }
}

