/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.reader;

import java.time.LocalDateTime;
import java.util.Scanner;
import org.jeasy.batch.core.reader.RecordReader;
import org.jeasy.batch.core.record.Header;
import org.jeasy.batch.core.record.StringRecord;

public class StringRecordReader
implements RecordReader<String> {
    private long currentRecordNumber;
    private Scanner scanner;
    private String dataSource;

    public StringRecordReader(String dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void open() {
        this.currentRecordNumber = 1L;
        this.scanner = new Scanner(this.dataSource);
    }

    public StringRecord readRecord() {
        Header header = new Header(this.currentRecordNumber++, this.getDataSourceName(), LocalDateTime.now());
        String payload = this.scanner.hasNextLine() ? this.scanner.nextLine() : null;
        return payload == null ? null : new StringRecord(header, payload);
    }

    private String getDataSourceName() {
        return "In-Memory String";
    }

    @Override
    public void close() {
        this.scanner.close();
    }
}

