/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;

public class Batch<P>
implements Iterable<Record<P>> {
    private List<Record<P>> records = new ArrayList<Record<P>>();

    public Batch() {
    }

    public Batch(Record<P> ... records) {
        Collections.addAll(this.records, records);
    }

    public Batch(List<Record<P>> records) {
        this.records = records;
    }

    public void addRecord(Record<P> record) {
        this.records.add(record);
    }

    public void removeRecord(Record<P> record) {
        this.records.remove(record);
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public long size() {
        return this.records.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Batch batch = (Batch)o;
        return this.records.equals(batch.records);
    }

    public int hashCode() {
        return this.records.hashCode();
    }

    @Override
    public Iterator<Record<P>> iterator() {
        return this.records.iterator();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Batch: {");
        stringBuilder.append(Utils.LINE_SEPARATOR);
        for (Record<P> record : this.records) {
            stringBuilder.append('\t');
            stringBuilder.append(record);
            stringBuilder.append(Utils.LINE_SEPARATOR);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

