/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.writer;

import java.util.List;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.writer.RecordWriter;

public class CompositeRecordWriter<P>
implements RecordWriter<P> {
    private List<RecordWriter<P>> writers;

    public CompositeRecordWriter(List<RecordWriter<P>> writers) {
        this.writers = writers;
    }

    @Override
    public void open() throws Exception {
        for (RecordWriter<P> writer : this.writers) {
            writer.open();
        }
    }

    @Override
    public void writeRecords(Batch<P> batch) throws Exception {
        for (RecordWriter<P> writer : this.writers) {
            writer.writeRecords(batch);
        }
    }

    @Override
    public void close() throws Exception {
        for (RecordWriter<P> writer : this.writers) {
            writer.close();
        }
    }
}

