/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.flatfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jeasy.batch.core.mapper.AbstractRecordMapper;
import org.jeasy.batch.core.mapper.ObjectMapper;
import org.jeasy.batch.core.mapper.RecordMapper;
import org.jeasy.batch.core.record.GenericRecord;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.flatfile.Field;

public class DelimitedRecordMapper<P>
extends AbstractRecordMapper<P>
implements RecordMapper<String, P> {
    public static final String DEFAULT_DELIMITER = ",";
    public static final String DEFAULT_QUALIFIER = "";
    public static final boolean DEFAULT_WHITESPACE_TRIMMING = false;
    private String delimiter = ",";
    private boolean trimWhitespaces = false;
    private String qualifier = "";
    private int recordExpectedLength;
    private List<Integer> fieldsPositions;
    private String[] fieldNames;
    private boolean fieldNamesRetrievedFromHeader;

    public DelimitedRecordMapper(Class<P> recordClass) {
        super(recordClass);
        this.objectMapper = new ObjectMapper(recordClass);
    }

    public DelimitedRecordMapper(Class<P> recordClass, String ... fieldNames) {
        this(recordClass);
        this.fieldNames = fieldNames;
        this.recordExpectedLength = fieldNames.length;
    }

    public DelimitedRecordMapper(Class<P> recordClass, String[] fieldNames, int recordExpectedLength) {
        this(recordClass, fieldNames);
        this.recordExpectedLength = recordExpectedLength;
    }

    public DelimitedRecordMapper(Class<P> recordClass, Integer ... fieldsPositions) {
        this(recordClass);
        this.fieldsPositions = Arrays.asList(fieldsPositions);
    }

    public DelimitedRecordMapper(Class<P> recordClass, Integer[] fieldsPositions, String[] fieldNames) {
        this(recordClass);
        this.fieldNames = fieldNames;
        this.fieldsPositions = Arrays.asList(fieldsPositions);
    }

    public DelimitedRecordMapper(Class<P> recordClass, Integer[] fieldsPositions, String[] fieldNames, int recordExpectedLength) {
        this(recordClass, fieldsPositions, fieldNames);
        this.recordExpectedLength = recordExpectedLength;
    }

    public Record<P> processRecord(Record<String> record) throws Exception {
        List<Field> fields = this.parseRecord(record);
        HashMap<String, String> fieldsContents = new HashMap<String, String>();
        int index = 0;
        for (Field field : fields) {
            String fieldName = this.fieldNamesRetrievedFromHeader ? this.fieldNames[field.getIndex()] : this.fieldNames[index++];
            String rawContent = field.getRawContent();
            fieldsContents.put(fieldName, rawContent);
        }
        return new GenericRecord(record.getHeader(), this.objectMapper.mapObject(fieldsContents));
    }

    protected List<Field> parseRecord(Record<String> record) throws Exception {
        String payload = (String)record.getPayload();
        String[] tokens = payload.split(this.delimiter, -1);
        this.setRecordExpectedLength(tokens);
        this.setFieldNames(tokens);
        this.checkRecordLength(tokens);
        this.checkQualifier(tokens);
        ArrayList<Field> fields = new ArrayList<Field>();
        int index = 0;
        for (String token : tokens) {
            token = this.trimWhitespaces(token);
            token = this.removeQualifier(token);
            fields.add(new Field(index++, token));
        }
        if (this.fieldsPositions != null) {
            this.filterFields(fields);
        }
        return fields;
    }

    private void checkQualifier(String[] tokens) throws Exception {
        if (this.qualifier.length() > 0) {
            for (String token : tokens) {
                if (token.startsWith(this.qualifier) && token.endsWith(this.qualifier)) continue;
                throw new Exception("field [" + token + "] is not enclosed as expected with '" + this.qualifier + "'");
            }
        }
    }

    private void checkRecordLength(String[] tokens) throws Exception {
        if (tokens.length != this.recordExpectedLength) {
            throw new Exception("record length (" + tokens.length + " fields) not equal to expected length of " + this.recordExpectedLength + " fields");
        }
    }

    private void setFieldNames(String[] tokens) {
        if (this.fieldNames == null) {
            this.fieldNamesRetrievedFromHeader = true;
            this.fieldNames = new String[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                token = this.trimWhitespaces(token);
                this.fieldNames[i] = token = this.removeQualifier(token);
            }
        }
    }

    private void setRecordExpectedLength(String[] tokens) {
        if (this.recordExpectedLength == 0) {
            this.recordExpectedLength = tokens.length;
        }
    }

    private void filterFields(List<Field> fields) {
        Iterator<Field> iterator = fields.iterator();
        while (iterator.hasNext()) {
            int index = iterator.next().getIndex();
            if (this.fieldsPositions.contains(index)) continue;
            iterator.remove();
        }
    }

    private String trimWhitespaces(String token) {
        if (this.trimWhitespaces) {
            return token.trim();
        }
        return token;
    }

    private String removeQualifier(String token) {
        int qualifierLength = this.qualifier.length();
        if (qualifierLength > 0) {
            return token.substring(qualifierLength, token.length() - qualifierLength);
        }
        return token;
    }

    public void setDelimiter(String delimiter) {
        String prefix = DEFAULT_QUALIFIER;
        if ("|".equals(delimiter)) {
            prefix = "\\";
        }
        this.delimiter = prefix + delimiter;
    }

    public void setTrimWhitespaces(boolean trimWhitespaces) {
        this.trimWhitespaces = trimWhitespaces;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }
}

