/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.flatfile;

import java.util.Iterator;
import org.jeasy.batch.core.field.BeanFieldExtractor;
import org.jeasy.batch.core.field.FieldExtractor;
import org.jeasy.batch.core.marshaller.RecordMarshaller;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.record.StringRecord;
import org.jeasy.batch.core.util.Utils;

public class DelimitedRecordMarshaller<P>
implements RecordMarshaller<P, String> {
    public static final String DEFAULT_DELIMITER = ",";
    public static final String DEFAULT_QUALIFIER = "\"";
    private String delimiter;
    private String qualifier;
    private FieldExtractor<P> fieldExtractor;

    public DelimitedRecordMarshaller(Class<P> type, String ... fields) {
        this((FieldExtractor<P>)new BeanFieldExtractor(type, fields));
    }

    public DelimitedRecordMarshaller(FieldExtractor<P> fieldExtractor) {
        Utils.checkNotNull(fieldExtractor, (String)"field extractor");
        this.fieldExtractor = fieldExtractor;
        this.delimiter = DEFAULT_DELIMITER;
        this.qualifier = DEFAULT_QUALIFIER;
    }

    public StringRecord processRecord(Record<P> record) throws Exception {
        Iterable values = this.fieldExtractor.extractFields(record.getPayload());
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            stringBuilder.append(this.qualifier);
            stringBuilder.append(value);
            stringBuilder.append(this.qualifier);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(this.delimiter);
        }
        return new StringRecord(record.getHeader(), stringBuilder.toString());
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }
}

