/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.flatfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jeasy.batch.core.mapper.AbstractRecordMapper;
import org.jeasy.batch.core.mapper.ObjectMapper;
import org.jeasy.batch.core.mapper.RecordMapper;
import org.jeasy.batch.core.record.GenericRecord;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.flatfile.Field;

public class FixedLengthRecordMapper<P>
extends AbstractRecordMapper<P>
implements RecordMapper<String, P> {
    public static final boolean DEFAULT_WHITESPACE_TRIMMING = false;
    private int[] fieldsLength;
    private int[] fieldsOffsets;
    private String[] fieldNames;
    private int recordExpectedLength;
    private boolean trimWhitespaces = false;

    public FixedLengthRecordMapper(Class<P> recordClass, int[] fieldsLength, String[] fieldNames) {
        super(recordClass);
        this.fieldsLength = (int[])fieldsLength.clone();
        this.fieldNames = (String[])fieldNames.clone();
        this.objectMapper = new ObjectMapper(recordClass);
        for (int fieldLength : fieldsLength) {
            this.recordExpectedLength += fieldLength;
        }
        this.fieldsOffsets = this.calculateOffsets(fieldsLength);
    }

    public Record<P> processRecord(Record<String> record) throws Exception {
        List<Field> fields = this.parseRecord(record);
        HashMap<String, String> fieldsContents = new HashMap<String, String>();
        for (Field field : fields) {
            String fieldName = this.fieldNames[field.getIndex()];
            String fieldValue = field.getRawContent();
            fieldsContents.put(fieldName, fieldValue);
        }
        return new GenericRecord(record.getHeader(), this.objectMapper.mapObject(fieldsContents));
    }

    protected List<Field> parseRecord(Record<String> record) throws Exception {
        String payload = (String)record.getPayload();
        int recordLength = payload.length();
        if (recordLength != this.recordExpectedLength) {
            throw new Exception("record length " + recordLength + " not equal to expected length of " + this.recordExpectedLength);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < this.fieldsLength.length; ++i) {
            String token = payload.substring(this.fieldsOffsets[i], this.fieldsOffsets[i + 1]);
            token = this.trimWhitespaces(token);
            Field field = new Field(i, token);
            fields.add(field);
        }
        return fields;
    }

    private int[] calculateOffsets(int[] lengths) {
        int[] offsets = new int[lengths.length + 1];
        offsets[0] = 0;
        for (int i = 0; i < lengths.length; ++i) {
            offsets[i + 1] = offsets[i] + lengths[i];
        }
        return offsets;
    }

    private String trimWhitespaces(String token) {
        if (this.trimWhitespaces) {
            return token.trim();
        }
        return token;
    }

    public void setTrimWhitespaces(boolean trimWhitespaces) {
        this.trimWhitespaces = trimWhitespaces;
    }
}

