/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.flatfile;

import java.util.Locale;
import java.util.stream.StreamSupport;
import org.jeasy.batch.core.field.BeanFieldExtractor;
import org.jeasy.batch.core.field.FieldExtractor;
import org.jeasy.batch.core.marshaller.RecordMarshaller;
import org.jeasy.batch.core.record.Header;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.record.StringRecord;
import org.jeasy.batch.core.util.Utils;

public class FixedLengthRecordMarshaller<P>
implements RecordMarshaller<P, String> {
    private FieldExtractor<P> fieldExtractor;
    private String format;
    private Locale locale = Locale.getDefault();

    public FixedLengthRecordMarshaller(Class<P> type, String format, String ... fields) {
        this((FieldExtractor<P>)new BeanFieldExtractor(type, fields), format);
    }

    public FixedLengthRecordMarshaller(FieldExtractor<P> fieldExtractor, String format) {
        Utils.checkNotNull(fieldExtractor, (String)"field extractor");
        Utils.checkNotNull((Object)format, (String)"format");
        this.fieldExtractor = fieldExtractor;
        this.format = format;
    }

    public StringRecord processRecord(Record<P> record) throws Exception {
        Header header = record.getHeader();
        Object[] fields = this.toArray(this.fieldExtractor.extractFields(record.getPayload()));
        String payload = String.format(this.locale, this.format, fields);
        return new StringRecord(header, payload);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private Object[] toArray(Iterable<Object> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).toArray(Object[]::new);
    }
}

