/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.flatfile;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.LocalDateTime;
import org.jeasy.batch.core.reader.AbstractFileRecordReader;
import org.jeasy.batch.core.record.Header;
import org.jeasy.batch.core.record.StringRecord;

public class FlatFileRecordReader
extends AbstractFileRecordReader<String> {
    private BufferedReader bufferedReader;
    private long currentRecordNumber;

    public FlatFileRecordReader(Path path) {
        this(path, Charset.defaultCharset());
    }

    public FlatFileRecordReader(Path path, Charset charset) {
        super(path, charset);
    }

    public StringRecord readRecord() throws IOException {
        Header header = new Header(Long.valueOf(++this.currentRecordNumber), this.getDataSourceName(), LocalDateTime.now());
        String line = this.bufferedReader.readLine();
        if (line != null) {
            return new StringRecord(header, line);
        }
        return null;
    }

    public void open() throws Exception {
        this.currentRecordNumber = 0L;
        this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.path.toFile()), this.charset));
    }

    public void close() throws IOException {
        if (this.bufferedReader != null) {
            this.bufferedReader.close();
        }
    }

    private String getDataSourceName() {
        return this.path.toAbsolutePath().toString();
    }
}

