/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.gson;

import com.google.gson.Gson;
import org.jeasy.batch.core.mapper.RecordMapper;
import org.jeasy.batch.core.record.GenericRecord;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;

public class GsonRecordMapper<T>
implements RecordMapper<String, T> {
    private Gson mapper;
    private Class<T> type;

    public GsonRecordMapper(Class<T> type) {
        this.type = type;
        this.mapper = new Gson();
    }

    public GsonRecordMapper(Gson mapper, Class<T> type) {
        Utils.checkNotNull((Object)mapper, (String)"Gson mapper");
        Utils.checkNotNull(type, (String)"target type");
        this.mapper = mapper;
        this.type = type;
    }

    public Record<T> processRecord(Record<String> record) {
        return new GenericRecord(record.getHeader(), this.mapper.fromJson((String)record.getPayload(), this.type));
    }
}

