/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Array;
import org.jeasy.random.EasyRandom;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.RandomizationContext;
import org.jeasy.random.randomizers.range.IntegerRangeRandomizer;

class ArrayPopulator {
    private final EasyRandom easyRandom;

    ArrayPopulator(EasyRandom easyRandom) {
        this.easyRandom = easyRandom;
    }

    Object getRandomArray(Class<?> fieldType, RandomizationContext context) {
        Class<?> componentType = fieldType.getComponentType();
        int randomSize = this.getRandomArraySize(context.getParameters());
        Object result = Array.newInstance(componentType, randomSize);
        for (int i = 0; i < randomSize; ++i) {
            Object randomElement = this.easyRandom.doPopulateBean(componentType, context);
            Array.set(result, i, randomElement);
        }
        return result;
    }

    private int getRandomArraySize(EasyRandomParameters parameters) {
        EasyRandomParameters.Range<Integer> collectionSizeRange = parameters.getCollectionSizeRange();
        return new IntegerRangeRandomizer(collectionSizeRange.getMin(), collectionSizeRange.getMax(), parameters.getSeed()).getRandomValue();
    }
}

