/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.stream.Collectors;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.RandomizationContextStackItem;
import org.jeasy.random.api.RandomizerContext;

class RandomizationContext
implements RandomizerContext {
    private final EasyRandomParameters parameters;
    private final Map<Class<?>, List<Object>> populatedBeans;
    private final Stack<RandomizationContextStackItem> stack;
    private final Class<?> type;
    private Object rootObject;

    RandomizationContext(Class<?> type, EasyRandomParameters parameters) {
        this.type = type;
        this.populatedBeans = new IdentityHashMap();
        this.stack = new Stack();
        this.parameters = parameters;
    }

    void addPopulatedBean(Class<?> type, Object object) {
        int objectPoolSize = this.parameters.getObjectPoolSize();
        List<Object> objects = this.populatedBeans.get(type);
        if (objects == null) {
            objects = new ArrayList<Object>(objectPoolSize);
        }
        if (objects.size() < objectPoolSize) {
            objects.add(object);
        }
        this.populatedBeans.put(type, objects);
    }

    Object getPopulatedBean(Class<?> type) {
        int actualPoolSize = this.populatedBeans.get(type).size();
        int randomIndex = actualPoolSize > 1 ? this.nextInt(0, actualPoolSize) : 0;
        return this.populatedBeans.get(type).get(randomIndex);
    }

    boolean hasAlreadyRandomizedType(Class<?> type) {
        return this.populatedBeans.containsKey(type) && this.populatedBeans.get(type).size() == this.parameters.getObjectPoolSize();
    }

    void pushStackItem(RandomizationContextStackItem field) {
        this.stack.push(field);
    }

    void popStackItem() {
        this.stack.pop();
    }

    String getFieldFullName(Field field) {
        List<String> pathToField = this.getStackedFieldNames();
        pathToField.add(field.getName());
        return String.join((CharSequence)".", this.toLowerCase(pathToField));
    }

    boolean hasExceededRandomizationDepth() {
        int currentRandomizationDepth = this.stack.size();
        return currentRandomizationDepth > this.parameters.getRandomizationDepth();
    }

    private List<String> getStackedFieldNames() {
        return this.stack.stream().map(i -> i.getField().getName()).collect(Collectors.toList());
    }

    private List<String> toLowerCase(List<String> strings) {
        return strings.stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    private int nextInt(int startInclusive, int endExclusive) {
        return startInclusive + new Random().nextInt(endExclusive - startInclusive);
    }

    void setRandomizedObject(Object randomizedObject) {
        if (this.rootObject == null) {
            this.rootObject = randomizedObject;
        }
    }

    @Override
    public Class<?> getTargetType() {
        return this.type;
    }

    @Override
    public Object getCurrentObject() {
        if (this.stack.empty()) {
            return this.rootObject;
        }
        return ((RandomizationContextStackItem)this.stack.lastElement()).getObject();
    }

    @Override
    public String getCurrentField() {
        return String.join((CharSequence)".", this.getStackedFieldNames());
    }

    @Override
    public int getCurrentRandomizationDepth() {
        return this.stack.size();
    }

    @Override
    public Object getRootObject() {
        return this.rootObject;
    }

    @Override
    public EasyRandomParameters getParameters() {
        return this.parameters;
    }
}

