/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.collection;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.number.ByteRandomizer;

public class MapRandomizer<K, V>
implements Randomizer<Map<K, V>> {
    private final int nbElements;
    private final Randomizer<K> keyRandomizer;
    private final Randomizer<V> valueRandomizer;

    public MapRandomizer(Randomizer<K> keyRandomizer, Randomizer<V> valueRandomizer) {
        this(keyRandomizer, valueRandomizer, MapRandomizer.getRandomSize());
    }

    public MapRandomizer(@NonNull Randomizer<K> keyRandomizer, @NonNull Randomizer<V> valueRandomizer, int nbEntries) {
        if (keyRandomizer == null) {
            throw new NullPointerException("keyRandomizer is marked non-null but is null");
        }
        if (valueRandomizer == null) {
            throw new NullPointerException("valueRandomizer is marked non-null but is null");
        }
        this.checkArguments(nbEntries);
        this.keyRandomizer = keyRandomizer;
        this.valueRandomizer = valueRandomizer;
        this.nbElements = nbEntries;
    }

    public static <K, V> MapRandomizer<K, V> aNewMapRandomizer(Randomizer<K> keyRandomizer, Randomizer<V> valueRandomizer) {
        return new MapRandomizer<K, V>(keyRandomizer, valueRandomizer, MapRandomizer.getRandomSize());
    }

    public static <K, V> MapRandomizer<K, V> aNewMapRandomizer(Randomizer<K> keyRandomizer, Randomizer<V> valueRandomizer, int nbEntries) {
        return new MapRandomizer<K, V>(keyRandomizer, valueRandomizer, nbEntries);
    }

    @Override
    public Map<K, V> getRandomValue() {
        HashMap<K, V> result = new HashMap<K, V>();
        for (int i = 0; i < this.nbElements; ++i) {
            result.put(this.keyRandomizer.getRandomValue(), this.valueRandomizer.getRandomValue());
        }
        return result;
    }

    private void checkArguments(int nbEntries) {
        if (nbEntries < 0) {
            throw new IllegalArgumentException("The number of entries to generate must be >= 0");
        }
    }

    private static int getRandomSize() {
        return Math.abs(ByteRandomizer.aNewByteRandomizer().getRandomValue().byteValue()) + 1;
    }
}

