/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.number;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.number.DoubleRandomizer;

public class BigDecimalRandomizer
implements Randomizer<BigDecimal> {
    private final DoubleRandomizer delegate;
    private Integer scale;
    private RoundingMode roundingMode = RoundingMode.HALF_UP;

    public BigDecimalRandomizer() {
        this.delegate = new DoubleRandomizer();
    }

    public BigDecimalRandomizer(long seed) {
        this.delegate = new DoubleRandomizer(seed);
    }

    public BigDecimalRandomizer(Integer scale) {
        this.delegate = new DoubleRandomizer();
        this.scale = scale;
    }

    public BigDecimalRandomizer(Integer scale, RoundingMode roundingMode) {
        this(scale);
        this.roundingMode = roundingMode;
    }

    public BigDecimalRandomizer(long seed, Integer scale, RoundingMode roundingMode) {
        this(seed);
        this.scale = scale;
        this.roundingMode = roundingMode;
    }

    public static BigDecimalRandomizer aNewBigDecimalRandomizer() {
        return new BigDecimalRandomizer();
    }

    public static BigDecimalRandomizer aNewBigDecimalRandomizer(long seed) {
        return new BigDecimalRandomizer(seed);
    }

    public static BigDecimalRandomizer aNewBigDecimalRandomizer(Integer scale) {
        return new BigDecimalRandomizer(scale);
    }

    public static BigDecimalRandomizer aNewBigDecimalRandomizer(Integer scale, RoundingMode roundingMode) {
        return new BigDecimalRandomizer(scale, roundingMode);
    }

    public static BigDecimalRandomizer aNewBigDecimalRandomizer(long seed, Integer scale, RoundingMode roundingMode) {
        return new BigDecimalRandomizer(seed, scale, roundingMode);
    }

    @Override
    public BigDecimal getRandomValue() {
        BigDecimal randomValue = new BigDecimal(this.delegate.getRandomValue());
        if (this.scale != null) {
            randomValue = randomValue.setScale((int)this.scale, this.roundingMode);
        }
        return randomValue;
    }
}

