/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.range.DoubleRangeRandomizer;

public class BigDecimalRangeRandomizer
implements Randomizer<BigDecimal> {
    private final DoubleRangeRandomizer delegate;
    private Integer scale;
    private RoundingMode roundingMode = RoundingMode.HALF_UP;

    public BigDecimalRangeRandomizer(Double min, Double max) {
        this.delegate = new DoubleRangeRandomizer(min, max);
    }

    public BigDecimalRangeRandomizer(Double min, Double max, long seed) {
        this.delegate = new DoubleRangeRandomizer(min, max, seed);
    }

    public BigDecimalRangeRandomizer(Double min, Double max, Integer scale) {
        this.delegate = new DoubleRangeRandomizer(min, max);
        this.scale = scale;
    }

    public BigDecimalRangeRandomizer(Double min, Double max, Integer scale, RoundingMode roundingMode) {
        this.delegate = new DoubleRangeRandomizer(min, max, (long)scale.intValue());
        this.roundingMode = roundingMode;
    }

    public BigDecimalRangeRandomizer(Double min, Double max, long seed, Integer scale) {
        this.delegate = new DoubleRangeRandomizer(min, max, seed);
        this.scale = scale;
    }

    public BigDecimalRangeRandomizer(Double min, Double max, long seed, Integer scale, RoundingMode roundingMode) {
        this.delegate = new DoubleRangeRandomizer(min, max, seed);
        this.scale = scale;
        this.roundingMode = roundingMode;
    }

    public static BigDecimalRangeRandomizer aNewBigDecimalRangeRandomizer(Double min, Double max) {
        return new BigDecimalRangeRandomizer(min, max);
    }

    public static BigDecimalRangeRandomizer aNewBigDecimalRangeRandomizer(Double min, Double max, long seed) {
        return new BigDecimalRangeRandomizer(min, max, seed);
    }

    public static BigDecimalRangeRandomizer aNewBigDecimalRangeRandomizer(Double min, Double max, Integer scale) {
        return new BigDecimalRangeRandomizer(min, max, scale);
    }

    public static BigDecimalRangeRandomizer aNewBigDecimalRangeRandomizer(Double min, Double max, Integer scale, RoundingMode roundingMode) {
        return new BigDecimalRangeRandomizer(min, max, scale, roundingMode);
    }

    public static BigDecimalRangeRandomizer aNewBigDecimalRangeRandomizer(Double min, Double max, long seed, Integer scale) {
        return new BigDecimalRangeRandomizer(min, max, seed, scale);
    }

    public static BigDecimalRangeRandomizer aNewBigDecimalRangeRandomizer(Double min, Double max, long seed, Integer scale, RoundingMode roundingMode) {
        return new BigDecimalRangeRandomizer(min, max, seed, scale, roundingMode);
    }

    @Override
    public BigDecimal getRandomValue() {
        Double delegateRandomValue = this.delegate.getRandomValue();
        BigDecimal randomValue = new BigDecimal(delegateRandomValue);
        if (this.scale != null) {
            randomValue = randomValue.setScale((int)this.scale, this.roundingMode);
        }
        return randomValue;
    }
}

