/*
 * The MIT License
 *
 * Copyright (c) 2014 Red Hat, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.jenkinsci.test.acceptance.plugins.html_publisher;

import org.jenkinsci.test.acceptance.po.*;

@Describable("Publish HTML reports")
public class HtmlPublisher extends AbstractStep implements PostBuildStep {
    public HtmlPublisher(Job parent, String path) {
        super(parent, path);
    }

    public Report addDir(String dir) {
        String path = createPageArea("reportTargets", () -> control("repeatable-add").click());
        Report report = new Report(parent, path);
        report.dir.set(dir);
        return report;
    }

    public static class Report extends PageAreaImpl {
        public final Control dir = control("reportDir");
        public final Control index = control("reportFiles");
        public final Control name = control("reportName");

        public Report(PageObject context, String path) {
            super(context, path);
        }
    }
}
