/*
 * The MIT License
 *
 * Copyright (c) 2014 Red Hat, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.jenkinsci.test.acceptance.po;


import java.net.URL;

/**
 * Global tools configuration UI.
 * <p>
 * Introduced in Jenkins 2.0.
 */
public class GlobalToolConfig extends ContainerPageObject {

    public GlobalToolConfig(Jenkins context) {
        super(context, context.url("configureTools/"));
    }

    @Override
    public URL getConfigUrl() {
        return url;
    }

    public <T extends ToolInstallation> T addTool(final Class<T> type) {
        final String name = type.getAnnotation(ToolInstallationPageObject.class).name();

        String path = createPageArea("configs", () -> clickButton("Add " + name));

        return newInstance(type, this, path);
    }
}
