/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.core.ArgTag;
import org.apache.commons.jelly.tags.core.ArgTagParent;
import org.apache.commons.jelly.util.ClassLoaderUtils;

public class InvokeStaticTag
extends TagSupport
implements ArgTagParent {
    private String var;
    private String exceptionVar;
    private String methodName;
    private String className;
    private List paramTypes = new ArrayList();
    private List paramValues = new ArrayList();

    public void setVar(String var) {
        this.var = var;
    }

    public void setExceptionVar(String var) {
        this.exceptionVar = var;
    }

    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void addArgument(Class type, Object value) {
        this.paramTypes.add(type);
        this.paramValues.add(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTag(XMLOutput output) throws JellyTagException {
        block12: {
            try {
                ArgTag parentArg;
                if (null == this.methodName) {
                    throw new MissingAttributeException("method");
                }
                this.invokeBody(output);
                Object[] values = this.paramValues.toArray();
                Class[] types = this.paramTypes.toArray(new Class[this.paramTypes.size()]);
                Method method = this.loadClass().getMethod(this.methodName, types);
                Object result = method.invoke(null, values);
                if (null != this.var) {
                    this.context.setVariable(this.var, result);
                }
                if (null != (parentArg = (ArgTag)this.findAncestorWithClass(ArgTag.class))) {
                    parentArg.setValue(result);
                }
            }
            catch (ClassNotFoundException e) {
                throw this.createLoadClassFailedException(e);
            }
            catch (NoSuchMethodException e) {
                throw this.createLoadClassFailedException(e);
            }
            catch (IllegalAccessException e) {
                throw this.createLoadClassFailedException(e);
            }
            catch (InvocationTargetException e) {
                if (null != this.exceptionVar) {
                    this.context.setVariable(this.exceptionVar, e.getTargetException());
                    break block12;
                }
                throw new JellyTagException("method " + this.methodName + " threw exception: " + e.getTargetException().getMessage(), e.getTargetException());
            }
            finally {
                this.paramTypes.clear();
                this.paramValues.clear();
            }
        }
    }

    protected Class loadClass() throws ClassNotFoundException {
        return ClassLoaderUtils.loadClass(this.className, this.getClass());
    }

    protected JellyTagException createLoadClassFailedException(Exception e) {
        return new JellyTagException("Could not load class: " + this.className + ". Reason: " + e, e);
    }
}

