/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.DateComparator;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;
import org.netbeans.lib.cvsclient.request.ModifiedRequest;
import org.netbeans.lib.cvsclient.request.QuestionableRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.StickyRequest;
import org.netbeans.lib.cvsclient.request.UnchangedRequest;

public abstract class BasicCommand
extends BuildableCommand {
    private static final long serialVersionUID = -1125981549032452939L;
    protected List<Request> requests = new LinkedList<Request>();
    protected ClientServices clientServices;
    private boolean recursive = true;
    protected File[] files;

    @Deprecated
    public boolean getRecursive() {
        return this.recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setFiles(File[] theFiles) {
        if (theFiles == null) {
            this.files = theFiles;
            return;
        }
        this.files = new File[theFiles.length];
        int fileCount = 0;
        int dirCount = 0;
        for (File currentFile : theFiles) {
            if (currentFile.isDirectory()) {
                this.files[totalCount - (1 + dirCount)] = currentFile;
                ++dirCount;
                continue;
            }
            this.files[fileCount] = currentFile;
            ++fileCount;
        }
    }

    public File[] getFiles() {
        return this.files;
    }

    public File getXthFile(int index) {
        if (index < 0 || index >= this.files.length) {
            return null;
        }
        File file = this.files[index];
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    public File getFileEndingWith(String ending) {
        String locEnding = ending.replace('\\', '/');
        String localDir = this.getLocalDirectory().replace('\\', '/');
        int index = 0;
        for (index = 0; index < this.files.length; ++index) {
            String path = this.files[index].getAbsolutePath();
            String parentPath = this.files[index].getParentFile().getAbsolutePath().replace('\\', '/');
            if ((!(path = path.replace('\\', '/')).endsWith(locEnding) || locEnding.indexOf(47) < 0) && (!this.files[index].getName().equals(locEnding) || !parentPath.equals(localDir))) continue;
            return this.files[index];
        }
        return null;
    }

    private void addRequests(File path) throws FileNotFoundException, IOException, CommandAbortedException {
        if (path == null) {
            throw new IllegalArgumentException("Cannot add requests for a null path.");
        }
        if (!path.exists() || path.isFile()) {
            this.addRequestsForFile(path);
        } else {
            this.addRequestsForDirectory(path);
        }
    }

    protected boolean doesCheckFileTime() {
        return true;
    }

    protected void sendEntryAndModifiedRequests(Entry entry, File file) {
        if (entry == null) {
            return;
        }
        if (file != null && !file.exists() && entry.isNewUserFile()) {
            return;
        }
        Date entryLastModified = entry.getLastModified();
        boolean hadConflicts = entry.hadConflicts();
        if (!hadConflicts) {
            entry.setConflict(null);
        } else if (this.fileRequiresConflictResolution(file, entry)) {
            Entry clone = new Entry(entry.toString());
            clone.setConflict("+=");
            entry = clone;
        }
        this.addRequest(new EntryRequest(entry));
        if (file == null || !file.exists() || entry.isUserFileToBeRemoved()) {
            return;
        }
        if (this.doesCheckFileTime() && !hadConflicts && entryLastModified != null && DateComparator.getInstance().equals(file.lastModified(), entryLastModified.getTime())) {
            this.addRequest(new UnchangedRequest(file.getName()));
            return;
        }
        this.addRequest(new ModifiedRequest(file, entry.isBinary()));
    }

    private final boolean fileRequiresConflictResolution(File file, Entry entry) {
        if (file == null) {
            return false;
        }
        boolean ret = false;
        if (entry.hadConflicts()) {
            long mergedTime = entry.getLastModified().getTime() / 1000L;
            long timeStampOfFile = file.lastModified() / 1000L;
            ret = timeStampOfFile <= mergedTime;
        }
        return ret;
    }

    protected void addRequestsForDirectory(File directory) throws IOException, CommandAbortedException {
        File[] subFiles;
        ArrayList<Object> localFiles;
        if (!this.clientServices.exists(directory)) {
            return;
        }
        if (this.clientServices.isAborted()) {
            throw new CommandAbortedException("Command aborted during request generation", "Command aborted during request generation");
        }
        this.addDirectoryRequest(directory);
        File[] dirFiles = directory.listFiles();
        if (dirFiles == null) {
            localFiles = new ArrayList(0);
        } else {
            localFiles = new ArrayList<File>(Arrays.asList(dirFiles));
            localFiles.remove(new File(directory, "CVS"));
        }
        LinkedList<File> subDirectories = null;
        if (this.isRecursive()) {
            subDirectories = new LinkedList<File>();
        }
        Iterator<Entry> it = this.clientServices.getEntries(directory);
        while (it.hasNext()) {
            Entry entry = it.next();
            File file = new File(directory, entry.getName());
            if (entry.isDirectory()) {
                if (this.isRecursive()) {
                    subDirectories.add(new File(directory, entry.getName()));
                }
            } else {
                this.addRequestForFile(file, entry);
            }
            localFiles.remove(file);
        }
        if (this.isRecursive() && !new File(directory, "CVS").exists() && (subFiles = directory.listFiles()) != null) {
            for (File subFile : subFiles) {
                if (!subFile.isDirectory() || !new File(subFile, "CVS").exists()) continue;
                subDirectories.add(subFile);
            }
        }
        for (File file : localFiles) {
            String localFileName = file.getName();
            if (this.clientServices.shouldBeIgnored(directory, localFileName)) continue;
            this.addRequest(new QuestionableRequest(localFileName));
        }
        if (this.isRecursive()) {
            for (File file : subDirectories) {
                File subdirectory = file;
                File cvsSubDir = new File(subdirectory, "CVS");
                if (!this.clientServices.exists(cvsSubDir)) continue;
                this.addRequestsForDirectory(subdirectory);
            }
        }
    }

    protected void addRequestForFile(File file, Entry entry) {
        this.sendEntryAndModifiedRequests(entry, file);
    }

    protected void addRequestsForFile(File file) throws IOException {
        this.addDirectoryRequest(file.getParentFile());
        Entry entry = this.clientServices.getEntry(file);
        if (entry != null) {
            this.addRequestForFile(file, entry);
        } else if (file.exists()) {
            boolean unusedBinaryFlag = false;
            this.addRequest(new ModifiedRequest(file, false));
        }
    }

    protected final void addDirectoryRequest(File directory) throws IOException {
        String dir = this.getRelativeToLocalPathInUnixStyle(directory);
        try {
            String repository = this.clientServices.getRepositoryForDirectory(directory.getAbsolutePath());
            this.addRequest(new DirectoryRequest(dir, repository));
            String tag2 = this.clientServices.getStickyTagForDirectory(directory);
            if (tag2 != null) {
                this.addRequest(new StickyRequest(tag2));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    protected void addArgumentRequests() {
        if (this.files == null) {
            return;
        }
        for (File file : this.files) {
            String relativePath = this.getRelativeToLocalPathInUnixStyle(file);
            this.addRequest(new ArgumentRequest(relativePath, true));
        }
    }

    @Override
    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        this.requests.clear();
        this.clientServices = client;
        super.execute(client, em);
        if (client.isFirstCommand()) {
            this.addRequest(new RootRequest(client.getRepository()));
        }
        this.addFileRequests();
    }

    private void addFileRequests() throws CommandException {
        try {
            if (this.files != null && this.files.length > 0) {
                for (File file : this.files) {
                    this.addRequests(file);
                }
            } else if (this.assumeLocalPathWhenUnspecified()) {
                this.addRequests(new File(this.getLocalDirectory()));
            }
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
    }

    protected boolean assumeLocalPathWhenUnspecified() {
        return true;
    }

    protected final void addRequest(Request request) {
        this.requests.add(request);
    }

    protected final void addRequestForWorkingDirectory(ClientServices clientServices) throws IOException {
        this.addRequest(new DirectoryRequest(".", clientServices.getRepositoryForDirectory(this.getLocalDirectory())));
    }

    protected final void addArgumentRequest(boolean value, String argument) {
        if (!value) {
            return;
        }
        this.addRequest(new ArgumentRequest(argument));
    }

    protected final void appendFileArguments(StringBuffer buffer) {
        File[] files = this.getFiles();
        if (files == null) {
            return;
        }
        for (int index = 0; index < files.length; ++index) {
            if (index > 0) {
                buffer.append(' ');
            }
            buffer.append(files[index].getName());
        }
    }
}

