/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.UnsupportedEncodingException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BinaryBuilder;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.PipedFilesBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.BinaryMessageEvent;
import org.netbeans.lib.cvsclient.event.EnhancedMessageEvent;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;

public abstract class BuildableCommand
extends Command {
    private static final long serialVersionUID = 2933928049689871087L;
    protected Builder builder;
    private final StringBuffer taggedLineBuffer = new StringBuffer();
    private boolean builderSet;

    @Override
    public void execute(ClientServices client, EventManager eventManager) throws CommandException, AuthenticationException {
        super.execute(client, eventManager);
        if (this.builder == null && !this.isBuilderSet()) {
            this.builder = this.createBuilder(eventManager);
        }
    }

    public Builder createBuilder(EventManager eventManager) {
        return null;
    }

    @Override
    public void messageSent(BinaryMessageEvent e) {
        super.messageSent(e);
        if (this.builder == null) {
            return;
        }
        if (this.builder instanceof BinaryBuilder) {
            BinaryBuilder binaryBuilder = (BinaryBuilder)((Object)this.builder);
            binaryBuilder.parseBytes(e.getMessage(), e.getMessageLength());
        }
    }

    @Override
    public void messageSent(MessageEvent e) {
        super.messageSent(e);
        if (this.builder == null) {
            return;
        }
        if (e instanceof EnhancedMessageEvent) {
            EnhancedMessageEvent eEvent = (EnhancedMessageEvent)e;
            this.builder.parseEnhancedMessage(eEvent.getKey(), eEvent.getValue());
            return;
        }
        if (e.isTagged()) {
            String message = MessageEvent.parseTaggedMessage(this.taggedLineBuffer, e.getMessage());
            if (message != null) {
                this.builder.parseLine(message, false);
                this.taggedLineBuffer.setLength(0);
            }
        } else {
            if (this.taggedLineBuffer.length() > 0) {
                this.builder.parseLine(this.taggedLineBuffer.toString(), false);
                this.taggedLineBuffer.setLength(0);
            }
            if (this.builder instanceof PipedFilesBuilder && !e.isError()) {
                try {
                    String iso88591 = new String(e.getRawData(), "ISO-8859-1");
                    this.builder.parseLine(iso88591, e.isError());
                }
                catch (UnsupportedEncodingException e1) {
                    assert (false);
                }
            } else {
                this.builder.parseLine(e.getMessage(), e.isError());
            }
        }
    }

    protected boolean isBuilderSet() {
        return this.builderSet;
    }

    public void setBuilder(Builder builder) {
        this.builder = builder;
        this.builderSet = true;
    }

    @Override
    public void commandTerminated(TerminationEvent e) {
        if (this.builder == null) {
            return;
        }
        if (this.taggedLineBuffer.length() > 0) {
            this.builder.parseLine(this.taggedLineBuffer.toString(), false);
            this.taggedLineBuffer.setLength(0);
        }
        this.builder.outputDone();
    }
}

