/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.add;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.command.add.AddInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class AddBuilder
implements Builder {
    private static final String ADDED = " added to the repository";
    private static final String PUT = " put under version control";
    private static final String SCHEDULING = ": scheduling file `";
    private static final String DIRECTORY = "Directory ";
    private static final String READDING = ": re-adding file ";
    private static final String RESURRECTED = ", resurrected";
    private static final String RESUR_VERSION = ", version ";
    private static final boolean DEBUG = false;
    private AddInformation addInformation;
    private final EventManager eventManager;
    private final AddCommand addCommand;

    public AddBuilder(EventManager eventManager, AddCommand addCommand) {
        this.eventManager = eventManager;
        this.addCommand = addCommand;
    }

    @Override
    public void outputDone() {
        if (this.addInformation != null) {
            FileInfoEvent event = new FileInfoEvent(this, this.addInformation);
            this.eventManager.fireCVSEvent(event);
            this.addInformation = null;
        }
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        if (line.endsWith(ADDED)) {
            String directory = line.substring(DIRECTORY.length(), line.indexOf(ADDED));
            this.addDirectory(directory);
        } else if (line.endsWith(PUT)) {
            String directory = line.substring(DIRECTORY.length(), line.indexOf(PUT));
            this.addDirectory(directory);
        } else if (line.indexOf(SCHEDULING) >= 0) {
            String filename = line.substring(line.indexOf(SCHEDULING) + SCHEDULING.length(), line.indexOf(39)).trim();
            this.addFile(filename);
        } else if (line.indexOf(READDING) >= 0) {
            String filename = line.substring(line.indexOf(READDING) + READDING.length(), line.indexOf(40)).trim();
            this.addFile(filename);
        } else if (line.endsWith(RESURRECTED)) {
            String filename = line.substring(0, line.length() - RESURRECTED.length());
            this.resurrectFile(filename);
        }
    }

    private File createFile(String fileName) {
        File locFile = this.addCommand.getFileEndingWith(fileName);
        if (locFile == null) {
            String name = fileName.replace('\\', '/');
            File[] files = this.addCommand.getFiles();
            name.length();
            File bestMatch = null;
            String[] paths = new String[files.length];
            for (int index = 0; index < files.length; ++index) {
                paths[index] = files[index].getAbsolutePath().replace('\\', '/');
            }
            int start = name.lastIndexOf(47);
            String part = null;
            part = start < 0 ? name : name.substring(start + 1);
            while (start >= 0 || part != null) {
                boolean wasMatch = false;
                for (int index = 0; index < paths.length; ++index) {
                    if (!paths[index].endsWith(part)) continue;
                    bestMatch = files[index];
                    wasMatch = true;
                }
                if ((start = name.lastIndexOf(47, start - 1)) < 0 || !wasMatch) break;
                part = name.substring(start + 1);
            }
            return bestMatch;
        }
        return locFile;
    }

    private void addDirectory(String name) {
        this.addInformation = new AddInformation();
        this.addInformation.setType("A");
        String dirName = name.replace('\\', '/');
        this.addInformation.setFile(this.createFile(dirName));
        this.outputDone();
    }

    private void addFile(String name) {
        this.addInformation = new AddInformation();
        this.addInformation.setFile(this.createFile(name));
        this.addInformation.setType("A");
        this.outputDone();
    }

    private void resurrectFile(String line) {
        int versionIndex = line.lastIndexOf(RESUR_VERSION);
        String version = line.substring(versionIndex + RESUR_VERSION.length()).trim();
        String cutLine = line.substring(0, versionIndex).trim();
        int fileIndex = cutLine.lastIndexOf(32);
        String name = cutLine.substring(fileIndex).trim();
        this.addInformation = new AddInformation();
        this.addInformation.setType("U");
        this.addInformation.setFile(this.createFile(name));
        this.outputDone();
    }

    @Override
    public void parseEnhancedMessage(String key, Object value) {
    }
}

