/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.annotate;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateInformation;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateLine;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class AnnotateBuilder
implements Builder {
    private static final String ANNOTATING = "Annotations for ";
    private static final String STARS = "***************";
    private AnnotateInformation annotateInformation;
    private final EventManager eventManager;
    private final String localPath;
    private final File tempDir;

    public AnnotateBuilder(EventManager eventManager, BasicCommand annotateCommand) {
        this.eventManager = eventManager;
        this.localPath = annotateCommand.getLocalDirectory();
        this.tempDir = annotateCommand.getGlobalOptions().getTempDir();
    }

    @Override
    public void outputDone() {
        if (this.annotateInformation == null) {
            return;
        }
        try {
            this.annotateInformation.closeTempFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.annotateInformation));
        this.annotateInformation = null;
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        if (isErrorMessage && line.startsWith(ANNOTATING)) {
            this.outputDone();
            this.annotateInformation = new AnnotateInformation(this.tempDir);
            this.annotateInformation.setFile(this.createFile(line.substring(ANNOTATING.length())));
            return;
        }
        if (isErrorMessage && line.startsWith(STARS)) {
            return;
        }
        if (!isErrorMessage) {
            this.processLines(line);
        }
    }

    private File createFile(String fileName) {
        return new File(this.localPath, fileName);
    }

    @Override
    public void parseEnhancedMessage(String key, Object value) {
    }

    private void processLines(String line) {
        if (this.annotateInformation != null) {
            try {
                this.annotateInformation.addToTempFile(line);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static AnnotateLine processLine(String line) {
        int indexOpeningBracket = line.indexOf(40);
        int indexClosingBracket = line.indexOf(41);
        AnnotateLine annLine = null;
        if (indexOpeningBracket > 0 && indexClosingBracket > indexOpeningBracket) {
            String revision = line.substring(0, indexOpeningBracket).trim();
            String userDate = line.substring(indexOpeningBracket + 1, indexClosingBracket);
            String contents = line.substring(indexClosingBracket + 3);
            int lastSpace = userDate.lastIndexOf(32);
            String user = userDate;
            String date = userDate;
            if (lastSpace > 0) {
                user = userDate.substring(0, lastSpace).trim();
                date = userDate.substring(lastSpace).trim();
            }
            annLine = new AnnotateLine();
            annLine.setContent(contents);
            annLine.setAuthor(user);
            annLine.setDateString(date);
            annLine.setRevision(revision);
        }
        return annLine;
    }
}

