/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.export;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.export.ExportCommand;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class ExportBuilder
implements Builder {
    private static final String FILE_INFOS = "MUARC?";
    private final EventManager eventManager;
    private final String localPath;
    private DefaultFileInfoContainer fileInfoContainer;

    public ExportBuilder(EventManager eventManager, ExportCommand exportCommand) {
        this.eventManager = eventManager;
        this.localPath = exportCommand.getLocalDirectory();
    }

    @Override
    public void outputDone() {
        if (this.fileInfoContainer == null) {
            return;
        }
        FileInfoEvent event = new FileInfoEvent(this, this.fileInfoContainer);
        this.eventManager.fireCVSEvent(event);
        this.fileInfoContainer = null;
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        if (line.length() > 2 && line.charAt(1) == ' ') {
            String firstChar = line.substring(0, 1);
            if (FILE_INFOS.indexOf(firstChar) >= 0) {
                String filename = line.substring(2).trim();
                this.processFile(firstChar, filename);
            } else {
                this.error(line);
            }
        }
    }

    @Override
    public void parseEnhancedMessage(String key, Object value) {
    }

    private void error(String line) {
        System.err.println("Don't know anything about: " + line);
    }

    private void processFile(String type, String filename) {
        this.outputDone();
        File file = new File(this.localPath, filename);
        this.fileInfoContainer = new DefaultFileInfoContainer();
        this.fileInfoContainer.setType(type);
        this.fileInfoContainer.setFile(file);
        this.outputDone();
    }
}

