/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.remove;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.remove.RemoveCommand;
import org.netbeans.lib.cvsclient.command.remove.RemoveInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class RemoveBuilder
implements Builder {
    private static final String SCHEDULING = ": scheduling `";
    private static final String STILL_IN_WORKING = ": file `";
    private static final String UNKNOWN_FILE = "?";
    private RemoveInformation removeInformation;
    private String fileDirectory;
    private final EventManager eventManager;
    private final RemoveCommand removeCommand;

    public RemoveBuilder(EventManager eventManager, RemoveCommand removeCommand) {
        this.eventManager = eventManager;
        this.removeCommand = removeCommand;
    }

    @Override
    public void outputDone() {
        if (this.removeInformation != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.removeInformation));
            this.removeInformation = null;
        }
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        String fn;
        int endingIndex;
        if (line.indexOf(SCHEDULING) >= 0) {
            endingIndex = line.indexOf(39);
            fn = line.substring(line.indexOf(SCHEDULING) + SCHEDULING.length(), endingIndex).trim();
            this.addFile(fn);
            this.removeInformation.setRemoved(true);
            this.outputDone();
        }
        if (line.startsWith(UNKNOWN_FILE)) {
            this.addFile(line.substring(UNKNOWN_FILE.length()));
            this.removeInformation.setRemoved(false);
            this.outputDone();
        }
        if (line.indexOf(STILL_IN_WORKING) >= 0) {
            endingIndex = line.indexOf(39);
            fn = line.substring(line.indexOf(STILL_IN_WORKING) + STILL_IN_WORKING.length(), endingIndex).trim();
            this.addFile(fn);
            this.removeInformation.setRemoved(false);
            this.outputDone();
        }
    }

    protected File createFile(String fileName) {
        StringBuffer path = new StringBuffer();
        path.append(this.removeCommand.getLocalDirectory());
        path.append(File.separator);
        if (this.fileDirectory == null) {
            File locFile = this.removeCommand.getFileEndingWith(fileName);
            if (locFile == null) {
                path.append(fileName);
            } else {
                path = new StringBuffer(locFile.getAbsolutePath());
            }
        } else {
            path.append(fileName);
        }
        String toReturn = path.toString();
        toReturn = toReturn.replace('/', File.separatorChar);
        return new File(path.toString());
    }

    protected void addFile(String name) {
        this.removeInformation = new RemoveInformation();
        this.removeInformation.setFile(this.createFile(name));
    }

    @Override
    public void parseEnhancedMessage(String key, Object value) {
    }
}

