/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.remove;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.remove.RemoveBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.util.BugLog;

public class RemoveCommand
extends BasicCommand {
    private static final long serialVersionUID = 914686034545951083L;
    private boolean deleteBeforeRemove;
    private boolean ignoreLocallyExistingFiles;

    public boolean isDeleteBeforeRemove() {
        return this.deleteBeforeRemove;
    }

    public void setDeleteBeforeRemove(boolean deleteBeforeRemove) {
        this.deleteBeforeRemove = deleteBeforeRemove;
    }

    @Deprecated
    public boolean doesIgnoreLocallyExistingFiles() {
        return this.ignoreLocallyExistingFiles;
    }

    public boolean isIgnoreLocallyExistingFiles() {
        return this.ignoreLocallyExistingFiles;
    }

    public void setIgnoreLocallyExistingFiles(boolean ignoreLocallyExistingFiles) {
        this.ignoreLocallyExistingFiles = ignoreLocallyExistingFiles;
    }

    @Override
    public Builder createBuilder(EventManager eventMan) {
        return new RemoveBuilder(eventMan, this);
    }

    @Override
    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        if (this.files == null || this.files.length == 0) {
            throw new CommandException("No files have been specified for removal.", CommandException.getLocalMessage("RemoveCommand.noFilesSpecified", null));
        }
        client.ensureConnection();
        if (this.isDeleteBeforeRemove()) {
            this.removeAll(this.files);
        }
        super.execute(client, em);
        try {
            this.addRequestForWorkingDirectory(client);
            this.addArgumentRequests();
            this.addRequest(CommandRequest.REMOVE);
            client.processRequests(this.requests);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    @Override
    protected void sendEntryAndModifiedRequests(Entry entry, File file) {
        super.sendEntryAndModifiedRequests(entry, this.isIgnoreLocallyExistingFiles() ? null : file);
        if (entry.getRevision().equals("0")) {
            try {
                this.clientServices.removeEntry(file);
            }
            catch (IOException exc) {
                BugLog.getInstance().showException(exc);
            }
        }
    }

    @Override
    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("remove ");
        toReturn.append(this.getCVSArguments());
        File[] files = this.getFiles();
        if (files != null) {
            for (File file : files) {
                toReturn.append(file.getName() + " ");
            }
        }
        return toReturn.toString();
    }

    @Override
    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'f') {
            this.setDeleteBeforeRemove(true);
        } else {
            return false;
        }
        return true;
    }

    private void removeAll(File[] filesToDel) throws CommandException {
        if (filesToDel == null) {
            return;
        }
        for (File element : filesToDel) {
            File file = element;
            if (file.exists() && file.isFile()) {
                if (file.delete()) continue;
                throw new CommandException("Cannot delete file " + file.getAbsolutePath(), CommandException.getLocalMessage("RemoveCommand.cannotDelete", new Object[]{file.getAbsolutePath()}));
            }
            if (!this.isRecursive() || file.getName().equalsIgnoreCase("CVS")) continue;
            this.removeAll(file.listFiles());
        }
    }

    @Override
    public String getOptString() {
        return "flR";
    }

    @Override
    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setDeleteBeforeRemove(false);
    }

    @Override
    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.isDeleteBeforeRemove()) {
            toReturn.append("-f ");
        }
        return toReturn.toString();
    }
}

