/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.status;

import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.status.StatusBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class StatusCommand
extends BasicCommand {
    private static final long serialVersionUID = 2351137326139689665L;
    private boolean includeTags;

    @Override
    public Builder createBuilder(EventManager eventManager) {
        return new StatusBuilder(eventManager, this);
    }

    @Override
    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        client.ensureConnection();
        super.execute(client, em);
        try {
            if (this.includeTags) {
                this.requests.add(1, new ArgumentRequest("-v"));
            }
            this.addRequestForWorkingDirectory(client);
            this.addArgumentRequests();
            this.addRequest(CommandRequest.STATUS);
            client.processRequests(this.requests);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new CommandException(e, e.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    public boolean isIncludeTags() {
        return this.includeTags;
    }

    public void setIncludeTags(boolean inclTags) {
        this.includeTags = inclTags;
    }

    @Override
    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    @Override
    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("status ");
        toReturn.append(this.getCVSArguments());
        File[] files = this.getFiles();
        if (files != null) {
            for (File file : files) {
                toReturn.append(file.getName());
                toReturn.append(' ');
            }
        }
        return toReturn.toString();
    }

    @Override
    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'v') {
            this.setIncludeTags(true);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public String getOptString() {
        return "Rlv";
    }

    @Override
    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setIncludeTags(false);
    }

    @Override
    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (this.isIncludeTags()) {
            toReturn.append("-v ");
        }
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        return toReturn.toString();
    }
}

