/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.commandLine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.commandLine.command.CommandProvider;

public class CommandFactory {
    private static final String[] COMMAND_CLASSES = new String[]{"Import", "add", "annotate", "checkout", "commit", "diff", "export", "locbundlecheck", "log", "rannotate", "remove", "rlog", "rtag", "status", "tag", "update"};
    private static CommandFactory instance;
    private Map<String, CommandProvider> commandProvidersByNames;

    private CommandFactory() {
        this.createCommandProviders();
    }

    private void createCommandProviders() {
        this.commandProvidersByNames = new HashMap<String, CommandProvider>();
        String packageName = CommandFactory.class.getPackage().getName() + ".command.";
        for (String element : COMMAND_CLASSES) {
            try {
                String[] synonyms;
                Class<?> providerClass = Class.forName(packageName + element);
                CommandProvider provider = (CommandProvider)providerClass.newInstance();
                this.commandProvidersByNames.put(provider.getName(), provider);
                for (String synonym : synonyms = provider.getSynonyms()) {
                    this.commandProvidersByNames.put(synonym, provider);
                }
            }
            catch (Exception e) {
                System.err.println("Creation of command '" + element + "' failed:");
                e.printStackTrace(System.err);
            }
        }
    }

    public static synchronized CommandFactory getDefault() {
        if (instance == null) {
            instance = new CommandFactory();
        }
        return instance;
    }

    public Command createCommand(String commandName, String[] args, int startingIndex, GlobalOptions gopt, String workingDir) throws IllegalArgumentException {
        CommandProvider provider = this.commandProvidersByNames.get(commandName);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown command: '" + commandName + "'");
        }
        return provider.createCommand(args, startingIndex, gopt, workingDir);
    }

    public CommandProvider getCommandProvider(String name) {
        return this.commandProvidersByNames.get(name);
    }

    public CommandProvider[] getCommandProviders() {
        HashSet<CommandProvider> providers = new HashSet<CommandProvider>(this.commandProvidersByNames.values());
        return providers.toArray(new CommandProvider[0]);
    }
}

