/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.commandLine;

public class GetOpt {
    private String[] theArgs = null;
    private int argCount = 0;
    private String optString = null;
    public boolean optErr = false;
    public static final int optEOF = -1;
    private int optIndex = 0;
    private String optArg = null;
    private int optPosition = 1;

    public GetOpt(String[] args, String opts) {
        this.theArgs = args;
        this.argCount = this.theArgs.length;
        this.optString = opts;
    }

    public int processArg(String arg, int n) {
        int value;
        try {
            value = Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            if (this.optErr) {
                System.err.println("processArg cannot process " + arg + " as an integer");
            }
            return n;
        }
        return value;
    }

    public int tryArg(int k, int n) {
        int value;
        try {
            value = this.processArg(this.theArgs[k], n);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (this.optErr) {
                System.err.println("tryArg: no theArgs[" + k + "]");
            }
            return n;
        }
        return value;
    }

    public long processArg(String arg, long n) {
        long value;
        try {
            value = Long.parseLong(arg);
        }
        catch (NumberFormatException e) {
            if (this.optErr) {
                System.err.println("processArg cannot process " + arg + " as a long");
            }
            return n;
        }
        return value;
    }

    public long tryArg(int k, long n) {
        long value;
        try {
            value = this.processArg(this.theArgs[k], n);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (this.optErr) {
                System.err.println("tryArg: no theArgs[" + k + "]");
            }
            return n;
        }
        return value;
    }

    public double processArg(String arg, double d) {
        double value;
        try {
            value = Double.valueOf(arg);
        }
        catch (NumberFormatException e) {
            if (this.optErr) {
                System.err.println("processArg cannot process " + arg + " as a double");
            }
            return d;
        }
        return value;
    }

    public double tryArg(int k, double d) {
        double value;
        try {
            value = this.processArg(this.theArgs[k], d);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (this.optErr) {
                System.err.println("tryArg: no theArgs[" + k + "]");
            }
            return d;
        }
        return value;
    }

    public float processArg(String arg, float f) {
        float value;
        try {
            value = Float.valueOf(arg).floatValue();
        }
        catch (NumberFormatException e) {
            if (this.optErr) {
                System.err.println("processArg cannot process " + arg + " as a float");
            }
            return f;
        }
        return value;
    }

    public float tryArg(int k, float f) {
        float value;
        try {
            value = this.processArg(this.theArgs[k], f);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (this.optErr) {
                System.err.println("tryArg: no theArgs[" + k + "]");
            }
            return f;
        }
        return value;
    }

    public boolean processArg(String arg, boolean b) {
        return Boolean.valueOf(arg);
    }

    public boolean tryArg(int k, boolean b) {
        boolean value;
        try {
            value = this.processArg(this.theArgs[k], b);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (this.optErr) {
                System.err.println("tryArg: no theArgs[" + k + "]");
            }
            return b;
        }
        return value;
    }

    public String tryArg(int k, String s) {
        String value;
        try {
            value = this.theArgs[k];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (this.optErr) {
                System.err.println("tryArg: no theArgs[" + k + "]");
            }
            return s;
        }
        return value;
    }

    private static void writeError(String msg, char ch) {
        System.err.println("GetOpt: " + msg + " -- " + ch);
    }

    public int optIndexGet() {
        return this.optIndex;
    }

    public void optIndexSet(int i) {
        this.optIndex = i;
    }

    public String optArgGet() {
        return this.optArg;
    }

    public int getopt() {
        this.optArg = null;
        if (this.theArgs == null || this.optString == null) {
            return -1;
        }
        if (this.optIndex < 0 || this.optIndex >= this.argCount) {
            return -1;
        }
        String thisArg = this.theArgs[this.optIndex];
        int argLength = thisArg.length();
        if (argLength <= 1 || thisArg.charAt(0) != '-') {
            return -1;
        }
        if (thisArg.equals("--")) {
            ++this.optIndex;
            return -1;
        }
        char ch = thisArg.charAt(this.optPosition);
        int pos = this.optString.indexOf(ch);
        if (pos == -1 || ch == ':') {
            if (this.optErr) {
                GetOpt.writeError("illegal option", ch);
            }
            ch = '?';
        } else if (pos < this.optString.length() - 1 && this.optString.charAt(pos + 1) == ':') {
            if (this.optPosition != argLength - 1) {
                this.optArg = thisArg.substring(this.optPosition + 1);
                this.optPosition = argLength - 1;
            } else {
                ++this.optIndex;
                if (this.optIndex < this.argCount && (this.theArgs[this.optIndex].charAt(0) != '-' || this.theArgs[this.optIndex].length() >= 2 && (this.optString.indexOf(this.theArgs[this.optIndex].charAt(1)) == -1 || this.theArgs[this.optIndex].charAt(1) == ':'))) {
                    this.optArg = this.theArgs[this.optIndex];
                } else {
                    if (this.optErr) {
                        GetOpt.writeError("option requires an argument", ch);
                    }
                    this.optArg = null;
                    ch = ':';
                }
            }
        }
        ++this.optPosition;
        if (this.optPosition >= argLength) {
            ++this.optIndex;
            this.optPosition = 1;
        }
        return ch;
    }

    public static void main(String[] args) {
        GetOpt go = new GetOpt(args, "Uab:f:h:w:");
        go.optErr = true;
        int ch = -1;
        boolean usagePrint = false;
        int aflg = 0;
        boolean bflg = false;
        String filename = "out";
        int width = 80;
        double height = 1.0;
        while ((ch = go.getopt()) != -1) {
            if ((char)ch == 'U') {
                usagePrint = true;
                continue;
            }
            if ((char)ch == 'a') {
                ++aflg;
                continue;
            }
            if ((char)ch == 'b') {
                bflg = go.processArg(go.optArgGet(), bflg);
                continue;
            }
            if ((char)ch == 'f') {
                filename = go.optArgGet();
                continue;
            }
            if ((char)ch == 'h') {
                height = go.processArg(go.optArgGet(), height);
                continue;
            }
            if ((char)ch == 'w') {
                width = go.processArg(go.optArgGet(), width);
                continue;
            }
            System.exit(1);
        }
        if (usagePrint) {
            System.out.println("Usage: -a -b bool -f file -h height -w width");
            System.exit(0);
        }
        System.out.println("These are all the command line arguments before processing with GetOpt:");
        for (String arg : args) {
            System.out.print(" " + arg);
        }
        System.out.println();
        System.out.println("-U " + usagePrint);
        System.out.println("-a " + aflg);
        System.out.println("-b " + bflg);
        System.out.println("-f " + filename);
        System.out.println("-h " + height);
        System.out.println("-w " + width);
        for (int k = go.optIndexGet(); k < args.length; ++k) {
            System.out.println("normal argument " + k + " is " + args[k]);
        }
    }
}

