/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import java.io.IOException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.UnconfiguredRequestException;
import org.netbeans.lib.cvsclient.request.UseUnchangedRequest;
import org.netbeans.lib.cvsclient.request.ValidRequestsRequest;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public abstract class AbstractConnection
implements Connection {
    private static final long serialVersionUID = 6278218334702665366L;
    private String repository = null;
    private LoggedDataInputStream inputStream;
    private LoggedDataOutputStream outputStream;

    @Override
    public LoggedDataInputStream getInputStream() {
        return this.inputStream;
    }

    protected final void setInputStream(LoggedDataInputStream inputStream) {
        if (this.inputStream == inputStream) {
            return;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.inputStream = inputStream;
    }

    @Override
    public LoggedDataOutputStream getOutputStream() {
        return this.outputStream;
    }

    protected final void setOutputStream(LoggedDataOutputStream outputStream) {
        if (this.outputStream == outputStream) {
            return;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.outputStream = outputStream;
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    protected void verifyProtocol() throws IOException {
        String response;
        int c;
        try {
            this.outputStream.writeBytes(new RootRequest(this.repository).getRequestString(), "US-ASCII");
            this.outputStream.writeBytes(new UseUnchangedRequest().getRequestString(), "US-ASCII");
            this.outputStream.writeBytes(new ValidRequestsRequest().getRequestString(), "US-ASCII");
            this.outputStream.writeBytes("noop \n", "US-ASCII");
        }
        catch (UnconfiguredRequestException e) {
            throw new RuntimeException("Internal error verifying CVS protocol: " + e.getMessage());
        }
        this.outputStream.flush();
        StringBuffer responseNameBuffer = new StringBuffer();
        while ((c = this.inputStream.read()) != -1) {
            responseNameBuffer.append((char)c);
            if (c != 10) continue;
        }
        if (!(response = responseNameBuffer.toString()).startsWith("Valid-requests")) {
            throw new IOException("Unexpected server response: " + response);
        }
    }
}

