/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionIdentity;
import org.netbeans.lib.cvsclient.connection.LocalConnection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.SSHConnection;

public class ConnectionFactory {
    private static ConnectionIdentity connectionIdentity = new ConnectionIdentity();

    protected ConnectionFactory() {
    }

    public static ConnectionIdentity getConnectionIdentity() {
        return connectionIdentity;
    }

    public static Connection getConnection(String cvsRoot) throws IllegalArgumentException {
        CVSRoot root = CVSRoot.parse(cvsRoot);
        return ConnectionFactory.getConnection(root);
    }

    public static Connection getConnection(CVSRoot root) throws IllegalArgumentException {
        if (root.isLocal()) {
            LocalConnection con = new LocalConnection();
            con.setRepository(root.getRepository());
            return con;
        }
        String method = root.getMethod();
        if (null == method || "server" == method || "ext" == method) {
            return new SSHConnection(root, connectionIdentity);
        }
        if ("pserver" == method) {
            PServerConnection con = new PServerConnection(root);
            return con;
        }
        throw new IllegalArgumentException("Unrecognized CVS Root: " + root);
    }
}

