/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.netbeans.lib.cvsclient.file.OutputStreamProvider;
import org.netbeans.lib.cvsclient.file.WriteTextFilePreprocessor;
import org.netbeans.lib.cvsclient.util.BugLog;
import org.netbeans.lib.cvsclient.util.ByteArray;

public class WriteRcsDiffFilePreprocessor
implements WriteTextFilePreprocessor {
    private static final long serialVersionUID = 2027110088476730991L;
    private static final int READ_REMAINING = -2;
    private String lineEnding = System.getProperty("line.separator");

    public String getLineEnding() {
        return this.lineEnding;
    }

    public void setLineEnding(String lineEnding) {
        this.lineEnding = lineEnding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void copyTextFileToLocation(InputStream processedInput, File fileToWrite, OutputStreamProvider customOutput) throws IOException {
        ReadInfo tempFileReader = null;
        OutputStream out = null;
        ReadInfo tempDiffReader = null;
        File tempFile = null;
        try {
            tempDiffReader = new ReadInfo(new BufferedInputStream(processedInput));
            tempFileReader = new ReadInfo(new BufferedInputStream(new FileInputStream(fileToWrite)));
            tempFile = File.createTempFile(".#merg", "cvs");
            out = new BufferedOutputStream(new FileOutputStream(tempFile));
            byte[] diff2 = tempDiffReader.readLine();
            while (diff2 != null && diff2.length > 0) {
                block48: {
                    int count;
                    int startLine;
                    if (diff2[0] == 100) {
                        startLine = WriteRcsDiffFilePreprocessor.getStart(diff2);
                        count = WriteRcsDiffFilePreprocessor.getLength(diff2);
                        if (startLine >= 0 && count > 0) {
                            this.readToLine(startLine - 1, tempFileReader, out);
                            this.readToLine(startLine - 1 + count, tempFileReader, null);
                            break block48;
                        } else {
                            BugLog.getInstance().bug("wrong parsing.." + new String(diff2));
                            throw new IOException();
                        }
                    }
                    if (diff2[0] == 97) {
                        startLine = WriteRcsDiffFilePreprocessor.getStart(diff2);
                        count = WriteRcsDiffFilePreprocessor.getLength(diff2);
                        if (startLine >= 0 && count > 0) {
                            this.readToLine(startLine, tempFileReader, out);
                            tempDiffReader.setLineNumber(0);
                            this.readToLine(count, tempDiffReader, out);
                        } else {
                            BugLog.getInstance().bug("wrong parsing.." + new String(diff2));
                            throw new IOException();
                        }
                    }
                }
                diff2 = tempDiffReader.readLine();
            }
            this.readToLine(-2, tempFileReader, out);
            if (tempFile == null) return;
            tempFileReader.close();
            out.close();
            InputStream in = null;
            OutputStream customOutputStream = customOutput.createOutputStream();
            try {
                in = new BufferedInputStream(new FileInputStream(tempFile));
                while (true) {
                    int ch;
                    if ((ch = in.read()) == -1) {
                        return;
                    }
                    customOutputStream.write(ch);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
                try {
                    customOutputStream.close();
                }
                catch (IOException ex) {}
            }
        }
        catch (Exception exc) {
            BugLog.getInstance().showException(exc);
            return;
        }
        finally {
            if (tempDiffReader != null) {
                try {
                    tempDiffReader.close();
                }
                catch (IOException ex) {}
            }
            if (tempFileReader != null) {
                try {
                    tempFileReader.close();
                }
                catch (IOException ex) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private void readToLine(int finalLine, ReadInfo reader, OutputStream out) throws IOException {
        while (reader.getLineNumber() < finalLine || finalLine == -2) {
            byte[] line = reader.readLine();
            if (line == null) {
                return;
            }
            if (out == null) continue;
            out.write(line);
            out.write(this.getLineEnding().getBytes());
        }
    }

    private static int indexOf(byte[] bytes, byte b) {
        return WriteRcsDiffFilePreprocessor.indexOf(bytes, b, 0);
    }

    private static int indexOf(byte[] bytes, byte b, int start) {
        int index = -1;
        for (int i = start; i < bytes.length; ++i) {
            if (bytes[i] != b) continue;
            index = i;
            break;
        }
        return index;
    }

    private static int getStart(byte[] diffLine) {
        int spacePos = WriteRcsDiffFilePreprocessor.indexOf(diffLine, (byte)32);
        if (spacePos > 0) {
            String number = new String(diffLine, 1, spacePos - 1);
            try {
                int toReturn = Integer.parseInt(number);
                return toReturn;
            }
            catch (NumberFormatException exc) {
                return -1;
            }
        }
        return -1;
    }

    private static int getLength(byte[] diffLine) {
        int spacePos = WriteRcsDiffFilePreprocessor.indexOf(diffLine, (byte)32);
        if (spacePos > 0) {
            int end = WriteRcsDiffFilePreprocessor.indexOf(diffLine, (byte)32, spacePos + 1);
            if (end < 0) {
                end = diffLine.length;
            }
            String number = new String(diffLine, spacePos + 1, end - spacePos - 1);
            try {
                int toReturn = Integer.parseInt(number);
                return toReturn;
            }
            catch (NumberFormatException exc) {
                return -1;
            }
        }
        return -1;
    }

    private static class ReadInfo {
        private static final boolean crLines = "\r".equals(System.getProperty("line.separator"));
        private final PushbackInputStream in;
        private int lineNumber;
        private final ByteArray line;

        public ReadInfo(InputStream in) {
            this.in = new PushbackInputStream(in, 1);
            this.lineNumber = 0;
            this.line = new ByteArray();
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public byte[] readLine() throws IOException {
            this.line.reset();
            boolean end = false;
            while (true) {
                int b;
                if ((b = this.in.read()) == -1) {
                    end = true;
                    break;
                }
                if (b == 10) {
                    ++this.lineNumber;
                    break;
                }
                if (b == 13) {
                    int next = this.in.read();
                    if (next == 10) {
                        ++this.lineNumber;
                        break;
                    }
                    this.in.unread(next);
                    if (crLines) {
                        ++this.lineNumber;
                        break;
                    }
                }
                this.line.add((byte)b);
            }
            byte[] bytes = this.line.getBytes();
            if (end && bytes.length == 0) {
                bytes = null;
            }
            return bytes;
        }

        public void close() throws IOException {
            if (this.in != null) {
                this.in.close();
            }
        }
    }
}

