/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.EOFException;
import java.io.IOException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

public final class ErrorMessageResponse
implements Response {
    private static final long serialVersionUID = 5070951566773234646L;
    private boolean terminating;
    private String message;

    @Override
    public void process(LoggedDataInputStream dis, ResponseServices services) throws ResponseException {
        try {
            String line = dis.readLine();
            this.terminating |= line.endsWith(" [server aborted]: received termination signal");
            this.terminating |= line.endsWith(" [server aborted]: received broken pipe signal");
            this.terminating |= line.endsWith(" [checkout aborted]: end of file from server (consult above messages if any)");
            this.terminating &= dis.available() == 0;
            this.message = line;
            MessageEvent event = new MessageEvent(this, line, true);
            services.getEventManager().fireCVSEvent(event);
        }
        catch (EOFException ex) {
            throw new ResponseException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException ex) {
            throw new ResponseException(ex);
        }
    }

    @Override
    public boolean isTerminalResponse() {
        return this.terminating;
    }

    public String getMessage() {
        return this.message;
    }
}

