/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.EOFException;
import java.io.IOException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.event.BinaryMessageEvent;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class MessageBinaryResponse
implements Response {
    private static final long serialVersionUID = 5100298813805708167L;
    private static final int CHUNK_SIZE = 262144;

    @Override
    public void process(LoggedDataInputStream dis, ResponseServices services) throws ResponseException {
        try {
            int numBytes;
            String numBytesStr = dis.readLine();
            try {
                numBytes = Integer.parseInt(numBytesStr);
            }
            catch (NumberFormatException nfex) {
                throw new ResponseException(nfex);
            }
            int chunk = Math.min(numBytes, 262144);
            byte[] bytes = new byte[chunk];
            while (numBytes > 0) {
                int len = dis.read(bytes, 0, chunk);
                if (len == -1) {
                    throw new ResponseException("EOF", CommandException.getLocalMessage("CommandException.EndOfFile", null));
                }
                chunk = Math.min(numBytes -= len, 262144);
                BinaryMessageEvent event = new BinaryMessageEvent(this, bytes, len);
                services.getEventManager().fireCVSEvent(event);
            }
        }
        catch (EOFException ex) {
            throw new ResponseException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException ex) {
            throw new ResponseException(ex);
        }
    }

    @Override
    public boolean isTerminalResponse() {
        return false;
    }
}

