/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class ModTimeResponse
implements Response {
    private static final long serialVersionUID = -313434446305055266L;
    protected static final DateFormat dateFormatter;
    private static final SimpleDateFormat[] rfc822DateFormats;
    protected static final String SERVER_DATE_FORMAT = "dd MMM yyyy HH:mm:ss";

    ModTimeResponse() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(LoggedDataInputStream dis, ResponseServices services) throws ResponseException {
        try {
            String dateString = dis.readLine();
            Date date = null;
            DateFormat dateFormat = dateFormatter;
            synchronized (dateFormat) {
                for (SimpleDateFormat dateFormat2 : rfc822DateFormats) {
                    try {
                        date = dateFormat2.parse(dateString);
                        break;
                    }
                    catch (ParseException ex) {
                    }
                }
                if (date == null) {
                    date = dateFormatter.parse(dateString.substring(0, dateString.length() - 6));
                }
            }
            if (date.getTime() < 0L) {
                if (date.getYear() < 100 && date.getYear() >= 70) {
                    date.setYear(date.getYear() + 1900);
                } else if (date.getYear() >= 0 && date.getYear() < 70) {
                    date.setYear(date.getYear() + 2000);
                } else {
                    date.setYear(2000 + date.getYear());
                }
            }
            services.setNextFileDate(date);
        }
        catch (Exception e) {
            throw new ResponseException(e);
        }
    }

    @Override
    public boolean isTerminalResponse() {
        return false;
    }

    static {
        rfc822DateFormats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH), new SimpleDateFormat("EEE, d MMM yyyy HH:mm z", Locale.ENGLISH), new SimpleDateFormat("d MMM yyyy HH:mm z", Locale.ENGLISH), new SimpleDateFormat("d MMM yyyy HH:mm:ss z", Locale.ENGLISH)};
        dateFormatter = new SimpleDateFormat(SERVER_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(Entry.getTimeZone());
    }
}

