/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.envinject;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import java.io.File;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.RunAction2;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.service.EnvInjectSavable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerProxy;

public class EnvInjectAction
implements RunAction2,
StaplerProxy {
    public static final String URL_NAME = "injectedEnvVars";
    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    protected transient Map<String, String> envMap;
    @CheckForNull
    private transient Run<?, ?> build;
    private transient Map<String, String> resultVariables;
    private transient File rootDir;
    @CheckForNull
    private transient Set<String> sensibleVariables;

    public void onAttached(Run<?, ?> run) {
        this.build = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.build = run;
    }

    @Deprecated
    public EnvInjectAction(@Nonnull AbstractBuild build, @CheckForNull Map<String, String> envMap) {
        this.build = build;
        this.envMap = envMap;
    }

    public EnvInjectAction(@CheckForNull Map<String, String> envMap) {
        this.envMap = envMap;
    }

    public void overrideAll(Map<String, String> all) {
        this.overrideAll(Collections.emptySet(), all);
    }

    public void overrideAll(@CheckForNull Set<String> sensibleVariables, @CheckForNull Map<String, String> all) {
        if (this.envMap == null) {
            return;
        }
        if (all == null) {
            return;
        }
        this.sensibleVariables = sensibleVariables;
        this.envMap.putAll(all);
    }

    @CheckForNull
    public Map<String, String> getEnvMap() {
        if (this.envMap == null) {
            try {
                HashMap result = this.getEnvironment(this.build);
                if (this.build != null) {
                    this.envMap = result == null ? new HashMap(0) : result;
                }
                return result == null ? null : UnmodifiableMap.decorate(result);
            }
            catch (EnvInjectException e) {
                return null;
            }
        }
        return UnmodifiableMap.decorate(this.envMap);
    }

    public String getIconFileName() {
        return "document-properties.gif";
    }

    public String getDisplayName() {
        return "Environment Variables";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    private Object writeReplace() throws ObjectStreamException {
        try {
            EnvInjectSavable dao = new EnvInjectSavable();
            Map<String, String> toWrite = this.getEnvMap();
            if (toWrite == null) {
                toWrite = Collections.emptyMap();
            }
            if (this.build == null && this.rootDir == null) {
                throw new InvalidObjectException("Cannot save the environment file. Action " + this + " has no associated run instance. Target root dir is unknown");
            }
            if (this.rootDir == null) {
                dao.saveEnvironment(this.build.getRootDir(), Maps.transformEntries(toWrite, (Maps.EntryTransformer)new Maps.EntryTransformer<String, String, String>(){

                    public String transformEntry(String key, String value) {
                        return EnvInjectAction.this.sensibleVariables != null && EnvInjectAction.this.sensibleVariables.contains(key) ? "********" : value;
                    }
                }));
            } else {
                dao.saveEnvironment(this.rootDir, toWrite);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return this;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="JENKINS-47574 - parent may be null during readResolve()")
    private static boolean runHasNoParent(@Nonnull Run<?, ?> run) {
        return run.getParent() == null;
    }

    @CheckForNull
    private Map<String, String> getEnvironment(@CheckForNull Run<?, ?> build) throws EnvInjectException {
        if (build == null) {
            return null;
        }
        if (EnvInjectAction.runHasNoParent(build)) {
            return null;
        }
        EnvInjectSavable dao = new EnvInjectSavable();
        return dao.getEnvironment(build.getRootDir());
    }

    @CheckForNull
    public Run<?, ?> getOwner() {
        return this.build;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Data migration")
    private Object readResolve() throws ObjectStreamException {
        if (this.resultVariables != null) {
            this.envMap = this.resultVariables;
            return this;
        }
        Map<String, String> resultMap = null;
        try {
            if (this.build != null) {
                resultMap = this.getEnvironment(this.build);
            } else if (this.rootDir != null) {
                EnvInjectSavable dao = new EnvInjectSavable();
                resultMap = dao.getEnvironment(this.rootDir);
            }
            if (resultMap != null) {
                this.envMap = resultMap;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return this;
    }

    public Object getTarget() {
        throw new UnsupportedOperationException();
    }

    @CheckForNull
    public Set<String> getSensibleVariables() {
        return this.sensibleVariables;
    }
}

