/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.envinject.service;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.remoting.Callable;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.util.DescribableList;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.service.EnvInjectActionRetriever;
import org.jenkinsci.lib.envinject.service.EnvInjectDetector;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Deprecated
@Restricted(value={NoExternalUse.class})
@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Deprecated code")
public class EnvVarsResolver
implements Serializable {
    public Map<String, String> getPollingEnvVars(AbstractProject project, Node node) throws EnvInjectException {
        EnvInjectDetector detector;
        if (project == null) {
            throw new NullPointerException("A project object must be set.");
        }
        AbstractBuild lastBuild = project.getLastBuild();
        if (lastBuild != null && (detector = new EnvInjectDetector()).isEnvInjectPluginInstalled()) {
            return this.getEnVars(lastBuild);
        }
        if (node == null) {
            return this.getFallBackMasterNode(project);
        }
        if (node.getRootPath() == null) {
            return this.getFallBackMasterNode(project);
        }
        return this.getDefaultEnvVarsJob(project, node);
    }

    public Map<String, String> getEnVars(AbstractBuild build) throws EnvInjectException {
        if (build == null) {
            throw new NullPointerException("A build object must be set.");
        }
        EnvInjectActionRetriever envInjectActionRetriever = new EnvInjectActionRetriever();
        Action envInjectAction = envInjectActionRetriever.getEnvInjectAction(build);
        if (envInjectAction != null) {
            try {
                Method method = envInjectAction.getClass().getMethod("getEnvMap", new Class[0]);
                return (Map)method.invoke((Object)envInjectAction, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new EnvInjectException(e);
            }
        }
        Node builtOn = build.getBuiltOn();
        if (builtOn == null) {
            return this.getFallBackMasterNode(build.getProject());
        }
        if (builtOn.getRootPath() == null) {
            return this.getFallBackMasterNode(build.getProject());
        }
        return this.getDefaultEnvVarsJob(build.getProject(), builtOn);
    }

    private Map<String, String> getFallBackMasterNode(AbstractProject project) throws EnvInjectException {
        Node masterNode = this.getMasterNode();
        if (masterNode == null) {
            return this.gatherEnvVarsMaster(project);
        }
        return this.getDefaultEnvVarsJob(project, masterNode);
    }

    @CheckForNull
    private Node getMasterNode() {
        Computer computer;
        Jenkins jenkins = Jenkins.getInstance();
        Computer computer2 = computer = jenkins != null ? jenkins.toComputer() : null;
        if (computer == null) {
            return null;
        }
        return computer.getNode();
    }

    public String resolveEnvVars(AbstractBuild build, String value) throws EnvInjectException {
        if (build == null) {
            throw new NullPointerException("A build object must be set.");
        }
        if (value == null) {
            return null;
        }
        return Util.replaceMacro((String)value, this.getEnVars(build));
    }

    private Map<String, String> getDefaultEnvVarsJob(AbstractProject project, Node node) throws EnvInjectException {
        assert (project != null);
        assert (node != null);
        assert (node.getRootPath() != null);
        Map<String, String> result = this.gatherEnvVarsMaster(project);
        result.putAll(this.gatherEnvVarsNode(project, node));
        result.putAll(this.gatherEnvVarsNodeProperties(node));
        return result;
    }

    private Map<String, String> gatherEnvVarsMaster(AbstractProject project) throws EnvInjectException {
        Jenkins jenkins = Jenkins.getActiveInstance();
        assert (project != null);
        EnvVars env = new EnvVars();
        env.put("JENKINS_SERVER_COOKIE", Util.getDigestOf((String)("ServerID:" + jenkins.getSecretKey())));
        env.put("HUDSON_SERVER_COOKIE", Util.getDigestOf((String)("ServerID:" + jenkins.getSecretKey())));
        env.put("JOB_NAME", project.getFullName());
        env.put("JENKINS_HOME", jenkins.getRootDir().getPath());
        env.put("HUDSON_HOME", jenkins.getRootDir().getPath());
        String rootUrl = jenkins.getRootUrl();
        if (rootUrl != null) {
            env.put("JENKINS_URL", rootUrl);
            env.put("HUDSON_URL", rootUrl);
            env.put("JOB_URL", rootUrl + project.getUrl());
        }
        return env;
    }

    private Map<String, String> gatherEnvVarsNodeProperties(Node node) throws EnvInjectException {
        DescribableList globalNodeProperties;
        EnvVars env = new EnvVars();
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && (globalNodeProperties = jenkins.getGlobalNodeProperties()) != null) {
            for (NodeProperty nodeProperty : globalNodeProperties) {
                if (nodeProperty == null || !(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
                env.putAll((Map)((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars());
            }
        }
        if (node != null) {
            DescribableList nodeProperties = node.getNodeProperties();
            for (NodeProperty nodeProperty : nodeProperties) {
                EnvVars envVars;
                if (nodeProperty == null || !(nodeProperty instanceof EnvironmentVariablesNodeProperty) || (envVars = ((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars()) == null) continue;
                for (Map.Entry entry : envVars.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (key == null || value == null) continue;
                    env.put(key, value);
                }
            }
        }
        return env;
    }

    private Map<String, String> gatherEnvVarsNode(@Nonnull AbstractProject project, @Nonnull Node node) throws EnvInjectException {
        assert (project != null);
        assert (node != null);
        FilePath p = node.getRootPath();
        if (p == null) {
            throw new EnvInjectException("Cannot get Node root path for node '" + node + "'. The node is offline or the path is not available");
        }
        try {
            EnvVars envVars = new EnvVars((Map)p.act((Callable)new SystemEnvVarsGetter()));
            envVars.put("NODE_NAME", node.getNodeName());
            envVars.put("NODE_LABELS", Util.join((Collection)node.getAssignedLabels(), (String)" "));
            FilePath wFilePath = project.getSomeWorkspace();
            if (wFilePath != null) {
                envVars.put("WORKSPACE", wFilePath.getRemote());
            }
            return envVars;
        }
        catch (IOException | InterruptedException ioe) {
            throw new EnvInjectException(ioe);
        }
    }

    private static final class SystemEnvVarsGetter
    extends MasterToSlaveCallable<Map<String, String>, EnvInjectException> {
        private SystemEnvVarsGetter() {
        }

        public Map<String, String> call() throws EnvInjectException {
            return EnvVars.masterEnvVars;
        }
    }
}

