/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.envinject.service;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Deprecated
@Restricted(value={NoExternalUse.class})
public class EnvInjectSavable {
    private static final String ENVINJECT_TXT_FILENAME = "injectedEnvVars.txt";
    private static final String TOKEN = "=";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Deprecated class")
    public Map<String, String> getEnvironment(File envInjectBaseDir) throws EnvInjectException {
        if (envInjectBaseDir == null) {
            throw new NullPointerException("A base directory of the envinject file must be set.");
        }
        File f = new File(envInjectBaseDir, ENVINJECT_TXT_FILENAME);
        if (!f.exists()) {
            return null;
        }
        try (FileReader fileReader = new FileReader(f);){
            HashMap<String, String> result = new HashMap<String, String>();
            this.fromTxt(fileReader, result);
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (IOException fne) {
            throw new EnvInjectException(fne);
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Deprecated class")
    public void saveEnvironment(@NonNull File rootDir, @NonNull Map<String, String> envMap) throws EnvInjectException {
        File f = new File(rootDir, ENVINJECT_TXT_FILENAME);
        try (FileWriter fileWriter = new FileWriter(f);){
            TreeMap<String, String> map2Write = new TreeMap<String, String>();
            map2Write.putAll(envMap);
            this.toTxt(map2Write, fileWriter);
        }
        catch (IOException ioe) {
            throw new EnvInjectException(ioe);
        }
    }

    private void fromTxt(FileReader fileReader, Map<String, String> result) throws EnvInjectException {
        try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, TOKEN);
                int tokens = tokenizer.countTokens();
                if (tokens != 2) continue;
                result.put(String.valueOf(tokenizer.nextElement()), String.valueOf(tokenizer.nextElement()));
            }
        }
        catch (IOException ioe) {
            throw new EnvInjectException(ioe);
        }
    }

    private void toTxt(Map<String, String> envMap, FileWriter fw) throws IOException {
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            fw.write(entry.getKey());
            fw.write(TOKEN);
            fw.write(entry.getValue());
            fw.write(System.lineSeparator());
        }
    }
}

