/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey;

import io.jenkins.cli.shaded.org.apache.sshd.agent.SshAgent;
import io.jenkins.cli.shaded.org.apache.sshd.agent.SshAgentFactory;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey.AbstractKeyPairIterator;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey.KeyAgentIdentity;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey.KeyPairIdentity;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.SignatureFactoriesManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.io.IOException;
import java.nio.channels.Channel;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class UserAuthPublicKeyIterator
extends AbstractKeyPairIterator<PublicKeyIdentity>
implements Channel {
    private final AtomicBoolean open = new AtomicBoolean(true);
    private Iterator<? extends PublicKeyIdentity> current;
    private SshAgent agent;

    public UserAuthPublicKeyIterator(ClientSession session, SignatureFactoriesManager signatureFactories) throws Exception {
        super(session);
        LinkedList<Stream<PublicKeyIdentity>> identities = new LinkedList<Stream<PublicKeyIdentity>>();
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No session factory manager");
        SshAgentFactory factory = manager.getAgentFactory();
        if (factory != null) {
            try {
                this.agent = Objects.requireNonNull(factory.createClient(manager), "No agent created");
                identities.add(this.agent.getIdentities().stream().map(kp -> new KeyAgentIdentity(this.agent, (PublicKey)kp.getKey(), (String)kp.getValue())));
            }
            catch (Exception e) {
                try {
                    this.closeAgent();
                }
                catch (Exception err) {
                    e.addSuppressed(err);
                }
                throw e;
            }
        }
        identities.add(Stream.of(KeyIdentityProvider.providerOf(session)).map(KeyIdentityProvider::loadKeys).flatMap(GenericUtils::stream).map(kp -> new KeyPairIdentity(signatureFactories, session, (KeyPair)kp)));
        this.current = identities.stream().flatMap(r -> r).iterator();
    }

    @Override
    public boolean hasNext() {
        if (!this.isOpen()) {
            return false;
        }
        return this.current.hasNext();
    }

    @Override
    public PublicKeyIdentity next() {
        if (!this.isOpen()) {
            throw new NoSuchElementException("Iterator is closed");
        }
        return this.current.next();
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            this.closeAgent();
        }
    }

    protected void closeAgent() throws IOException {
        if (this.agent != null) {
            try {
                this.agent.close();
            }
            finally {
                this.agent = null;
            }
        }
    }
}

