/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.io.mina;

import io.jenkins.cli.shaded.org.apache.mina.core.RuntimeIoException;
import io.jenkins.cli.shaded.org.apache.mina.core.buffer.IoBuffer;
import io.jenkins.cli.shaded.org.apache.mina.core.service.IoProcessor;
import io.jenkins.cli.shaded.org.apache.mina.core.session.IdleStatus;
import io.jenkins.cli.shaded.org.apache.mina.core.session.IoSessionConfig;
import io.jenkins.cli.shaded.org.apache.mina.transport.socket.SocketSessionConfig;
import io.jenkins.cli.shaded.org.apache.mina.transport.socket.nio.NioSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.Closeable;
import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoService;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.mina.MinaSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.mina.MinaSupport;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable.AbstractCloseable;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public abstract class MinaService
extends AbstractCloseable
implements IoService,
io.jenkins.cli.shaded.org.apache.mina.core.service.IoHandler,
Closeable {
    protected final FactoryManager manager;
    protected final IoHandler handler;
    protected final IoProcessor<NioSession> ioProcessor;
    protected IoSessionConfig sessionConfig;

    public MinaService(FactoryManager manager, IoHandler handler, IoProcessor<NioSession> ioProcessor) {
        this.manager = manager;
        this.handler = handler;
        this.ioProcessor = ioProcessor;
    }

    protected abstract io.jenkins.cli.shaded.org.apache.mina.core.service.IoService getIoService();

    public void dispose() {
        io.jenkins.cli.shaded.org.apache.mina.core.service.IoService ioService = this.getIoService();
        ioService.dispose();
    }

    @Override
    protected void doCloseImmediately() {
        io.jenkins.cli.shaded.org.apache.mina.core.service.IoService ioService = this.getIoService();
        ioService.dispose();
        super.doCloseImmediately();
    }

    @Override
    public Map<Long, IoSession> getManagedSessions() {
        io.jenkins.cli.shaded.org.apache.mina.core.service.IoService ioService = this.getIoService();
        Map managedMap = ioService.getManagedSessions();
        TreeMap mina = new TreeMap(managedMap);
        TreeMap<Long, IoSession> sessions = new TreeMap<Long, IoSession>(Comparator.naturalOrder());
        for (Long id : mina.keySet()) {
            io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession minaSession = (io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession)mina.get(id);
            IoSession session = this.getSession(minaSession);
            if (session == null) continue;
            sessions.put(id, session);
        }
        return sessions;
    }

    public void sessionOpened(io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession session) throws Exception {
    }

    public void sessionIdle(io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession session, IdleStatus status) throws Exception {
    }

    public void messageSent(io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession session, Object message) throws Exception {
    }

    public void inputClosed(io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession session) throws Exception {
        session.closeNow();
    }

    public void sessionCreated(io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession session) throws Exception {
        MinaSession ioSession = new MinaSession(this, session);
        session.setAttribute(IoSession.class, (Object)ioSession);
        this.handler.sessionCreated(ioSession);
    }

    public void sessionClosed(io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession session) throws Exception {
        this.handler.sessionClosed(this.getSession(session));
    }

    public void exceptionCaught(io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession session, Throwable cause) throws Exception {
        this.handler.exceptionCaught(this.getSession(session), cause);
    }

    public void messageReceived(io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession session, Object message) throws Exception {
        this.handler.messageReceived(this.getSession(session), MinaSupport.asReadable((IoBuffer)message));
    }

    protected IoSession getSession(io.jenkins.cli.shaded.org.apache.mina.core.session.IoSession session) {
        return (IoSession)session.getAttribute(IoSession.class);
    }

    protected void configure(SocketSessionConfig config) {
        Integer intVal;
        Boolean boolVal = this.getBoolean("socket-keepalive");
        if (boolVal != null) {
            try {
                config.setKeepAlive(boolVal.booleanValue());
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, "socket-keepalive", boolVal, t);
            }
        }
        if ((intVal = this.getInteger("socket-sndbuf")) != null) {
            try {
                config.setSendBufferSize(intVal.intValue());
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, "socket-sndbuf", intVal, t);
            }
        }
        if ((intVal = this.getInteger("socket-rcvbuf")) != null) {
            try {
                config.setReceiveBufferSize(intVal.intValue());
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, "socket-rcvbuf", intVal, t);
            }
        }
        if ((intVal = this.getInteger("socket-linger")) != null) {
            try {
                config.setSoLinger(intVal.intValue());
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, "socket-linger", intVal, t);
            }
        }
        if ((boolVal = this.getBoolean("tcp-nodelay")) != null) {
            try {
                config.setTcpNoDelay(boolVal.booleanValue());
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, "tcp-nodelay", boolVal, t);
            }
        }
        if (this.sessionConfig != null) {
            config.setAll(this.sessionConfig);
        }
    }

    protected void handleConfigurationError(SocketSessionConfig config, String propName, Object propValue, RuntimeIoException t) {
        Throwable e = GenericUtils.resolveExceptionCause(t);
        this.log.warn("handleConfigurationError({}={}) failed ({}) to configure: {}", propName, propValue, e.getClass().getSimpleName(), e.getMessage());
    }

    protected Integer getInteger(String property) {
        return this.manager.getInteger(property);
    }

    protected Boolean getBoolean(String property) {
        return this.manager.getBoolean(property);
    }
}

