/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.jakarta.xml.bind.util;

import io.jenkins.cli.shaded.jakarta.xml.bind.JAXBContext;
import io.jenkins.cli.shaded.jakarta.xml.bind.JAXBException;
import io.jenkins.cli.shaded.jakarta.xml.bind.Marshaller;
import io.jenkins.cli.shaded.jakarta.xml.bind.util.Messages;
import io.jenkins.cli.shaded.org.xml.sax.ContentHandler;
import io.jenkins.cli.shaded.org.xml.sax.DTDHandler;
import io.jenkins.cli.shaded.org.xml.sax.EntityResolver;
import io.jenkins.cli.shaded.org.xml.sax.ErrorHandler;
import io.jenkins.cli.shaded.org.xml.sax.InputSource;
import io.jenkins.cli.shaded.org.xml.sax.SAXException;
import io.jenkins.cli.shaded.org.xml.sax.SAXNotRecognizedException;
import io.jenkins.cli.shaded.org.xml.sax.SAXParseException;
import io.jenkins.cli.shaded.org.xml.sax.XMLFilter;
import io.jenkins.cli.shaded.org.xml.sax.XMLReader;
import io.jenkins.cli.shaded.org.xml.sax.ext.LexicalHandler;
import io.jenkins.cli.shaded.org.xml.sax.helpers.XMLFilterImpl;
import javax.xml.transform.sax.SAXSource;

public class JAXBSource
extends SAXSource {
    private final Marshaller marshaller;
    private final Object contentObject;
    private final XMLReader pseudoParser = new XMLReader(){
        private LexicalHandler lexicalHandler;
        private EntityResolver entityResolver;
        private DTDHandler dtdHandler;
        private XMLFilter repeater = new XMLFilterImpl();
        private ErrorHandler errorHandler;

        public boolean getFeature(String name) throws SAXNotRecognizedException {
            if (name.equals("http://xml.org/sax/features/namespaces")) {
                return true;
            }
            if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
                return false;
            }
            throw new SAXNotRecognizedException(name);
        }

        public void setFeature(String name, boolean value) throws SAXNotRecognizedException {
            if (name.equals("http://xml.org/sax/features/namespaces") && value) {
                return;
            }
            if (name.equals("http://xml.org/sax/features/namespace-prefixes") && !value) {
                return;
            }
            throw new SAXNotRecognizedException(name);
        }

        public Object getProperty(String name) throws SAXNotRecognizedException {
            if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
                return this.lexicalHandler;
            }
            throw new SAXNotRecognizedException(name);
        }

        public void setProperty(String name, Object value) throws SAXNotRecognizedException {
            if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
                this.lexicalHandler = (LexicalHandler)value;
                return;
            }
            throw new SAXNotRecognizedException(name);
        }

        public void setEntityResolver(EntityResolver resolver) {
            this.entityResolver = resolver;
        }

        public EntityResolver getEntityResolver() {
            return this.entityResolver;
        }

        public void setDTDHandler(DTDHandler handler) {
            this.dtdHandler = handler;
        }

        public DTDHandler getDTDHandler() {
            return this.dtdHandler;
        }

        public void setContentHandler(ContentHandler handler) {
            this.repeater.setContentHandler(handler);
        }

        public ContentHandler getContentHandler() {
            return this.repeater.getContentHandler();
        }

        public void setErrorHandler(ErrorHandler handler) {
            this.errorHandler = handler;
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public void parse(InputSource input) throws SAXException {
            this.parse();
        }

        public void parse(String systemId) throws SAXException {
            this.parse();
        }

        public void parse() throws SAXException {
            try {
                JAXBSource.this.marshaller.marshal(JAXBSource.this.contentObject, (ContentHandler)((XMLFilterImpl)this.repeater));
            }
            catch (JAXBException e) {
                SAXParseException se = new SAXParseException(e.getMessage(), null, null, -1, -1, (Exception)e);
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(se);
                }
                throw se;
            }
        }
    };

    public JAXBSource(JAXBContext context, Object contentObject) throws JAXBException {
        this(context == null ? JAXBSource.assertionFailed(Messages.format("JAXBSource.NullContext")) : context.createMarshaller(), contentObject == null ? JAXBSource.assertionFailed(Messages.format("JAXBSource.NullContent")) : contentObject);
    }

    public JAXBSource(Marshaller marshaller, Object contentObject) throws JAXBException {
        if (marshaller == null) {
            throw new JAXBException(Messages.format("JAXBSource.NullMarshaller"));
        }
        if (contentObject == null) {
            throw new JAXBException(Messages.format("JAXBSource.NullContent"));
        }
        this.marshaller = marshaller;
        this.contentObject = contentObject;
        super.setXMLReader(this.pseudoParser);
        super.setInputSource(new InputSource());
    }

    private static Marshaller assertionFailed(String message) throws JAXBException {
        throw new JAXBException(message);
    }
}

