/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.httpclient.HttpClientConverter;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import hidden.jth.org.apache.http.client.utils.URLEncodedUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlForm
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlForm.class);
    public static final String TAG_NAME = "form";
    private static final String ATTRIBUTE_NOVALIDATE = "novalidate";
    public static final String ATTRIBUTE_FORMNOVALIDATE = "formnovalidate";
    private static final HashSet<String> SUBMITTABLE_ELEMENT_NAMES = new HashSet<String>(Arrays.asList("input", "button", "select", "textarea", "isindex"));
    private static final Pattern SUBMIT_CHARSET_PATTERN = Pattern.compile("[ ,].*");
    private final List<HtmlElement> lostChildren_ = new ArrayList<HtmlElement>();
    private boolean isPreventDefault_;

    HtmlForm(String qualifiedName, SgmlPage htmlPage, Map<String, DomAttr> attributes) {
        super(qualifiedName, htmlPage, attributes);
    }

    public void submit(SubmittableElement submitElement) {
        HtmlPage htmlPage = (HtmlPage)this.getPage();
        WebClient webClient = htmlPage.getWebClient();
        if (webClient.isJavaScriptEnabled()) {
            String action;
            if (submitElement != null) {
                HtmlButton htmlButton;
                this.isPreventDefault_ = false;
                boolean validate = true;
                if (submitElement instanceof HtmlSubmitInput && ((HtmlSubmitInput)submitElement).isFormNoValidate()) {
                    validate = false;
                } else if (submitElement instanceof HtmlButton && "submit".equalsIgnoreCase((htmlButton = (HtmlButton)submitElement).getType()) && htmlButton.isFormNoValidate()) {
                    validate = false;
                }
                if (validate && this.getAttributeDirect(ATTRIBUTE_NOVALIDATE) != ATTRIBUTE_NOT_DEFINED) {
                    validate = false;
                }
                if (validate && !this.areChildrenValid()) {
                    return;
                }
                ScriptResult scriptResult = this.fireEvent("submit");
                if (this.isPreventDefault_) {
                    if (scriptResult == null) {
                        return;
                    }
                    return;
                }
            }
            if (StringUtils.startsWithIgnoreCase(action = this.getActionAttribute().trim(), "javascript:")) {
                htmlPage.executeJavaScript(action, "Form action", this.getStartLineNumber());
                return;
            }
        } else if (StringUtils.startsWithIgnoreCase(this.getActionAttribute(), "javascript:")) {
            return;
        }
        if (submitElement != null) {
            this.updateHtml5Attributes(submitElement);
        }
        WebRequest request = this.getWebRequest(submitElement);
        String target = htmlPage.getResolvedTarget(this.getTargetAttribute());
        WebWindow webWindow = htmlPage.getEnclosingWindow();
        boolean forceDownload = webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_SUBMIT_FORCES_DOWNLOAD);
        boolean checkHash = !webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.FORM_SUBMISSION_DOWNLOWDS_ALSO_IF_ONLY_HASH_CHANGED);
        webClient.download(webWindow, target, request, checkHash, forceDownload, false, "JS form.submit()");
    }

    private void updateHtml5Attributes(SubmittableElement submitElement) {
        if (submitElement instanceof HtmlElement) {
            String formenctype;
            String formtarget;
            String formmethod;
            BrowserVersion browser;
            HtmlElement element = (HtmlElement)((Object)submitElement);
            String type = element.getAttributeDirect("type");
            boolean typeImage = false;
            boolean isInput = "input".equals(element.getTagName());
            if (isInput) {
                typeImage = "image".equalsIgnoreCase(type);
            }
            if ((browser = this.getPage().getWebClient().getBrowserVersion()).hasFeature(BrowserVersionFeatures.FORM_PARAMETRS_NOT_SUPPORTED_FOR_IMAGE) && typeImage) {
                return;
            }
            boolean typeSubmit = "submit".equalsIgnoreCase(type);
            if (isInput && !typeSubmit && !typeImage) {
                return;
            }
            if ("button".equals(element.getTagName()) && !"submit".equals(((HtmlButton)element).getType())) {
                return;
            }
            String formaction = element.getAttributeDirect("formaction");
            if (DomElement.ATTRIBUTE_NOT_DEFINED != formaction) {
                this.setActionAttribute(formaction);
            }
            if (DomElement.ATTRIBUTE_NOT_DEFINED != (formmethod = element.getAttributeDirect("formmethod"))) {
                this.setMethodAttribute(formmethod);
            }
            if (DomElement.ATTRIBUTE_NOT_DEFINED != (formtarget = element.getAttributeDirect("formtarget"))) {
                this.setTargetAttribute(formtarget);
            }
            if (DomElement.ATTRIBUTE_NOT_DEFINED != (formenctype = element.getAttributeDirect("formenctype"))) {
                this.setEnctypeAttribute(formenctype);
            }
        }
    }

    private boolean areChildrenValid() {
        boolean valid = true;
        for (HtmlElement element : this.getFormHtmlElementDescendants()) {
            if (!(element instanceof HtmlInput) || element.isValid()) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Form validation failed; element '" + element + "' was not valid. Submit cancelled."));
            }
            valid = false;
            break;
        }
        return valid;
    }

    public WebRequest getWebRequest(SubmittableElement submitElement) {
        WebRequest request;
        BrowserVersion browser;
        HttpMethod method;
        block21: {
            URL url;
            HtmlPage htmlPage = (HtmlPage)this.getPage();
            List<NameValuePair> parameters = this.getParameterListForSubmit(submitElement);
            String methodAttribute = this.getMethodAttribute();
            if ("post".equalsIgnoreCase(methodAttribute)) {
                method = HttpMethod.POST;
            } else {
                if (!"get".equalsIgnoreCase(methodAttribute) && StringUtils.isNotBlank(methodAttribute)) {
                    this.notifyIncorrectness("Incorrect submit method >" + this.getMethodAttribute() + "<. Using >GET<.");
                }
                method = HttpMethod.GET;
            }
            browser = this.getPage().getWebClient().getBrowserVersion();
            String actionUrl = this.getActionAttribute();
            String anchor = null;
            String queryFormFields = "";
            Charset enc = this.getSubmitCharset();
            if (StandardCharsets.UTF_16 == enc) {
                enc = StandardCharsets.UTF_8;
            }
            if (HttpMethod.GET == method) {
                if (actionUrl.contains("#")) {
                    anchor = StringUtils.substringAfter(actionUrl, "#");
                }
                queryFormFields = URLEncodedUtils.format(HttpClientConverter.nameValuePairsToHttpClient(parameters), enc);
                actionUrl = StringUtils.substringBefore(actionUrl, "#");
                actionUrl = StringUtils.substringBefore(actionUrl, "?");
                parameters.clear();
            }
            try {
                url = actionUrl.isEmpty() ? WebClient.expandUrl(htmlPage.getUrl(), actionUrl) : htmlPage.getFullyQualifiedUrl(actionUrl);
                if (!queryFormFields.isEmpty()) {
                    url = UrlUtils.getUrlWithNewQuery(url, queryFormFields);
                }
                if (HttpMethod.GET == method && browser.hasFeature(BrowserVersionFeatures.FORM_SUBMISSION_URL_WITHOUT_HASH) && UrlUtils.URL_ABOUT_BLANK != url) {
                    url = UrlUtils.getUrlWithNewRef(url, null);
                } else if (HttpMethod.POST == method && browser.hasFeature(BrowserVersionFeatures.FORM_SUBMISSION_URL_WITHOUT_HASH) && UrlUtils.URL_ABOUT_BLANK != url && StringUtils.isEmpty(actionUrl)) {
                    url = UrlUtils.getUrlWithNewRef(url, null);
                } else if (anchor != null && UrlUtils.URL_ABOUT_BLANK != url) {
                    url = UrlUtils.getUrlWithNewRef(url, anchor);
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Not a valid url: " + actionUrl, e);
            }
            request = new WebRequest(url, browser.getHtmlAcceptHeader(), browser.getAcceptEncodingHeader());
            request.setHttpMethod(method);
            request.setRequestParameters(parameters);
            if (HttpMethod.POST == method) {
                request.setEncodingType(FormEncodingType.getInstance(this.getEnctypeAttribute()));
            }
            request.setCharset(enc);
            request.setRefererlHeader(htmlPage.getUrl());
            if (HttpMethod.POST == method && browser.hasFeature(BrowserVersionFeatures.FORM_SUBMISSION_HEADER_ORIGIN)) {
                try {
                    request.setAdditionalHeader("Origin", UrlUtils.getUrlWithProtocolAndAuthority(htmlPage.getUrl()).toExternalForm());
                }
                catch (MalformedURLException e) {
                    if (!LOG.isWarnEnabled()) break block21;
                    LOG.info((Object)("Invalid origin url '" + htmlPage.getUrl() + "'"));
                }
            }
        }
        if (HttpMethod.POST == method) {
            if (browser.hasFeature(BrowserVersionFeatures.FORM_SUBMISSION_HEADER_CACHE_CONTROL_MAX_AGE)) {
                request.setAdditionalHeader("Cache-Control", "max-age=0");
            }
            if (browser.hasFeature(BrowserVersionFeatures.FORM_SUBMISSION_HEADER_CACHE_CONTROL_NO_CACHE)) {
                request.setAdditionalHeader("Cache-Control", "no-cache");
            }
        }
        return request;
    }

    private Charset getSubmitCharset() {
        String charset = this.getAcceptCharsetAttribute();
        if (!charset.isEmpty()) {
            charset = charset.trim();
            return EncodingSniffer.toCharset(SUBMIT_CHARSET_PATTERN.matcher(charset).replaceAll("").toUpperCase(Locale.ROOT));
        }
        return this.getPage().getCharset();
    }

    public List<NameValuePair> getParameterListForSubmit(SubmittableElement submitElement) {
        Collection<SubmittableElement> submittableElements = this.getSubmittableElements(submitElement);
        ArrayList<NameValuePair> parameterList = new ArrayList<NameValuePair>(submittableElements.size());
        for (SubmittableElement element : submittableElements) {
            parameterList.addAll(Arrays.asList(element.getSubmitNameValuePairs()));
        }
        return parameterList;
    }

    public Page reset() {
        SgmlPage htmlPage = this.getPage();
        ScriptResult scriptResult = this.fireEvent("reset");
        if (ScriptResult.isFalse(scriptResult)) {
            return htmlPage.getWebClient().getCurrentWindow().getEnclosedPage();
        }
        for (HtmlElement next : this.getHtmlElementDescendants()) {
            if (!(next instanceof SubmittableElement)) continue;
            ((SubmittableElement)((Object)next)).reset();
        }
        return htmlPage;
    }

    Collection<SubmittableElement> getSubmittableElements(SubmittableElement submitElement) {
        String formId;
        ArrayList<SubmittableElement> submittableElements = new ArrayList<SubmittableElement>();
        for (HtmlElement htmlElement : this.getFormHtmlElementDescendants()) {
            if (!HtmlForm.isSubmittable(htmlElement, submitElement)) continue;
            submittableElements.add((SubmittableElement)((Object)htmlElement));
        }
        if (this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.FORM_SUBMISSION_FORM_ATTRIBUTE) && (formId = this.getId()) != ATTRIBUTE_NOT_DEFINED) {
            for (DomNode domNode : ((HtmlPage)this.getPage()).getBody().getDescendants()) {
                SubmittableElement submittable;
                HtmlElement element;
                String formIdRef;
                if (!(domNode instanceof HtmlElement) || !formId.equals(formIdRef = (element = (HtmlElement)domNode).getAttribute(TAG_NAME)) || !HtmlForm.isSubmittable(element, submitElement) || submittableElements.contains(submittable = (SubmittableElement)((Object)element))) continue;
                submittableElements.add(submittable);
            }
        }
        for (HtmlElement htmlElement : this.lostChildren_) {
            if (!HtmlForm.isSubmittable(htmlElement, submitElement)) continue;
            submittableElements.add((SubmittableElement)((Object)htmlElement));
        }
        return submittableElements;
    }

    private static boolean isValidForSubmission(HtmlElement element, SubmittableElement submitElement) {
        HtmlInput input;
        String tagName = element.getTagName();
        if (!SUBMITTABLE_ELEMENT_NAMES.contains(tagName)) {
            return false;
        }
        if (element.hasAttribute("disabled")) {
            return false;
        }
        if (element == submitElement && element instanceof HtmlImageInput) {
            return true;
        }
        if (!"isindex".equals(tagName) && !element.hasAttribute("name")) {
            return false;
        }
        if (!"isindex".equals(tagName) && "".equals(element.getAttributeDirect("name"))) {
            return false;
        }
        if (element instanceof HtmlInput && (input = (HtmlInput)element).isCheckable()) {
            return ((HtmlInput)element).isChecked();
        }
        if ("select".equals(tagName)) {
            return ((HtmlSelect)element).isValidForSubmission();
        }
        return true;
    }

    private static boolean isSubmittable(HtmlElement element, SubmittableElement submitElement) {
        HtmlInput input;
        if (!HtmlForm.isValidForSubmission(element, submitElement)) {
            return false;
        }
        if (element == submitElement) {
            return true;
        }
        if (element instanceof HtmlInput && !(input = (HtmlInput)element).isSubmitable()) {
            return false;
        }
        return !"button".equals(element.getTagName());
    }

    public List<HtmlInput> getInputsByName(String name) {
        List<HtmlInput> list = this.getFormElementsByAttribute("input", "name", name);
        for (HtmlElement elt : this.getLostChildren()) {
            if (!(elt instanceof HtmlInput) || !name.equals(elt.getAttributeDirect("name"))) continue;
            list.add((HtmlInput)elt);
        }
        return list;
    }

    private <E extends HtmlElement> List<E> getFormElementsByAttribute(String elementName, String attributeName, String attributeValue) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        String lowerCaseTagName = elementName.toLowerCase(Locale.ROOT);
        for (HtmlElement next : this.getFormHtmlElementDescendants()) {
            String attValue;
            if (!next.getTagName().equals(lowerCaseTagName) || !(attValue = next.getAttribute(attributeName)).equals(attributeValue)) continue;
            list.add(next);
        }
        return list;
    }

    private Iterable<HtmlElement> getFormHtmlElementDescendants() {
        DomNode.DescendantElementsIterator<HtmlElement> iter = new DomNode.DescendantElementsIterator<HtmlElement>(HtmlElement.class){
            private boolean filterChildrenOfNestedForms_;

            @Override
            protected boolean isAccepted(DomNode node) {
                if (node instanceof HtmlForm) {
                    this.filterChildrenOfNestedForms_ = true;
                    return false;
                }
                boolean accepted = super.isAccepted(node);
                if (accepted && this.filterChildrenOfNestedForms_) {
                    return ((HtmlElement)node).getEnclosingForm() == HtmlForm.this;
                }
                return accepted;
            }
        };
        return () -> iter;
    }

    public final <I extends HtmlInput> I getInputByName(String name) throws ElementNotFoundException {
        List<HtmlInput> inputs = this.getInputsByName(name);
        if (inputs.isEmpty()) {
            throw new ElementNotFoundException("input", "name", name);
        }
        return (I)inputs.get(0);
    }

    public List<HtmlSelect> getSelectsByName(String name) {
        List<HtmlSelect> list = this.getFormElementsByAttribute("select", "name", name);
        for (HtmlElement elt : this.getLostChildren()) {
            if (!(elt instanceof HtmlSelect) || !name.equals(elt.getAttributeDirect("name"))) continue;
            list.add((HtmlSelect)elt);
        }
        return list;
    }

    public HtmlSelect getSelectByName(String name) throws ElementNotFoundException {
        List<HtmlSelect> list = this.getSelectsByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("select", "name", name);
        }
        return list.get(0);
    }

    public List<HtmlButton> getButtonsByName(String name) {
        List<HtmlButton> list = this.getFormElementsByAttribute("button", "name", name);
        for (HtmlElement elt : this.getLostChildren()) {
            if (!(elt instanceof HtmlButton) || !name.equals(elt.getAttributeDirect("name"))) continue;
            list.add((HtmlButton)elt);
        }
        return list;
    }

    public HtmlButton getButtonByName(String name) throws ElementNotFoundException {
        List<HtmlButton> list = this.getButtonsByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("button", "name", name);
        }
        return list.get(0);
    }

    public List<HtmlTextArea> getTextAreasByName(String name) {
        List<HtmlTextArea> list = this.getFormElementsByAttribute("textarea", "name", name);
        for (HtmlElement elt : this.getLostChildren()) {
            if (!(elt instanceof HtmlTextArea) || !name.equals(elt.getAttributeDirect("name"))) continue;
            list.add((HtmlTextArea)elt);
        }
        return list;
    }

    public HtmlTextArea getTextAreaByName(String name) throws ElementNotFoundException {
        List<HtmlTextArea> list = this.getTextAreasByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("textarea", "name", name);
        }
        return list.get(0);
    }

    public List<HtmlRadioButtonInput> getRadioButtonsByName(String name) {
        WebAssert.notNull("name", name);
        ArrayList<HtmlRadioButtonInput> results = new ArrayList<HtmlRadioButtonInput>();
        for (HtmlElement htmlElement : this.getInputsByName(name)) {
            if (!(htmlElement instanceof HtmlRadioButtonInput)) continue;
            results.add((HtmlRadioButtonInput)htmlElement);
        }
        return results;
    }

    void setCheckedRadioButton(HtmlRadioButtonInput radioButtonInput) {
        if (radioButtonInput.getEnclosingForm() == null && !this.lostChildren_.contains(radioButtonInput)) {
            throw new IllegalArgumentException("HtmlRadioButtonInput is not child of this HtmlForm");
        }
        List<HtmlRadioButtonInput> radios = this.getRadioButtonsByName(radioButtonInput.getNameAttribute());
        for (HtmlRadioButtonInput input : radios) {
            input.setCheckedInternal(input == radioButtonInput);
        }
    }

    public HtmlRadioButtonInput getCheckedRadioButton(String name) {
        WebAssert.notNull("name", name);
        for (HtmlRadioButtonInput input : this.getRadioButtonsByName(name)) {
            if (!input.isChecked()) continue;
            return input;
        }
        return null;
    }

    public final String getActionAttribute() {
        return this.getAttributeDirect("action");
    }

    public final void setActionAttribute(String action) {
        this.setAttribute("action", action);
    }

    public final String getMethodAttribute() {
        return this.getAttributeDirect("method");
    }

    public final void setMethodAttribute(String method) {
        this.setAttribute("method", method);
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final void setNameAttribute(String name) {
        this.setAttribute("name", name);
    }

    public final String getEnctypeAttribute() {
        return this.getAttributeDirect("enctype");
    }

    public final void setEnctypeAttribute(String encoding) {
        this.setAttribute("enctype", encoding);
    }

    public final String getOnSubmitAttribute() {
        return this.getAttributeDirect("onsubmit");
    }

    public final String getOnResetAttribute() {
        return this.getAttributeDirect("onreset");
    }

    public final String getAcceptAttribute() {
        return this.getAttribute("accept");
    }

    public final String getAcceptCharsetAttribute() {
        return this.getAttribute("accept-charset");
    }

    public final String getTargetAttribute() {
        return this.getAttributeDirect("target");
    }

    public final void setTargetAttribute(String target) {
        this.setAttribute("target", target);
    }

    public final String getRelAttribute() {
        return this.getAttributeDirect("rel");
    }

    public <I extends HtmlInput> I getInputByValue(String value) throws ElementNotFoundException {
        List<HtmlInput> list = this.getInputsByValue(value);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("input", "value", value);
        }
        return (I)list.get(0);
    }

    public List<HtmlInput> getInputsByValue(String value) {
        List<HtmlInput> results = this.getFormElementsByAttribute("input", "value", value);
        for (HtmlElement element : this.getLostChildren()) {
            if (!(element instanceof HtmlInput) || !value.equals(element.getAttributeDirect("value"))) continue;
            results.add((HtmlInput)element);
        }
        return results;
    }

    public void addLostChild(HtmlElement field) {
        this.lostChildren_.add(field);
        field.setOwningForm(this);
    }

    public List<HtmlElement> getLostChildren() {
        return this.lostChildren_;
    }

    @Override
    protected void preventDefault() {
        this.isPreventDefault_ = true;
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    public final boolean isNoValidate() {
        return this.hasAttribute(ATTRIBUTE_NOVALIDATE);
    }

    public final void setNoValidate(boolean noValidate) {
        if (noValidate) {
            this.setAttribute(ATTRIBUTE_NOVALIDATE, ATTRIBUTE_NOVALIDATE);
        } else {
            this.removeAttribute(ATTRIBUTE_NOVALIDATE);
        }
    }
}

