/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.css.ComputedCssStyleDeclaration;
import com.gargoylesoftware.htmlunit.css.CssPixelValueConverter;
import com.gargoylesoftware.htmlunit.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlCanvas;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlData;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLegend;
import com.gargoylesoftware.htmlunit.html.HtmlOutput;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSlot;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.HtmlTime;
import com.gargoylesoftware.htmlunit.html.HtmlUnknownElement;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Text;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashSet;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;

@JsxClass(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR}, className="CSS2Properties")
public class ComputedCSSStyleDeclaration
extends CSSStyleDeclaration {
    @JsxConstructor
    public ComputedCSSStyleDeclaration() {
    }

    public ComputedCSSStyleDeclaration(Element element, ComputedCssStyleDeclaration cssStyleDeclaration) {
        super(element, cssStyleDeclaration);
    }

    @Override
    public ComputedCssStyleDeclaration getCssStyleDeclaration() {
        return (ComputedCssStyleDeclaration)super.getCssStyleDeclaration();
    }

    @Override
    protected void setStyleAttribute(String name, String newValue) {
    }

    private String defaultIfEmpty(String str, StyleAttributes.Definition definition) {
        return this.defaultIfEmpty(str, definition, false);
    }

    private String defaultIfEmpty(String str, StyleAttributes.Definition definition, boolean isPixel) {
        if (!this.getDomElement().isAttachedToPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_STYLE_PROP_DISCONNECTED_IS_EMPTY)) {
            return ComputedCssStyleDeclaration.EMPTY_FINAL;
        }
        if (str == null || str.isEmpty()) {
            return definition.getDefaultComputedValue(this.getBrowserVersion());
        }
        if (isPixel) {
            return ComputedCSSStyleDeclaration.pixelString(str);
        }
        return str;
    }

    private String defaultIfEmpty(String str, String toReturnIfEmptyOrDefault, String defaultValue) {
        if (!this.getDomElement().isAttachedToPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_STYLE_PROP_DISCONNECTED_IS_EMPTY)) {
            return ComputedCssStyleDeclaration.EMPTY_FINAL;
        }
        if (str == null || str.isEmpty() || str.equals(defaultValue)) {
            return toReturnIfEmptyOrDefault;
        }
        return str;
    }

    @Override
    public String getAccelerator() {
        return this.defaultIfEmpty(this.getStyleAttribute(StyleAttributes.Definition.ACCELERATOR, false), StyleAttributes.Definition.ACCELERATOR);
    }

    @Override
    public String getBackgroundAttachment() {
        return this.defaultIfEmpty(super.getBackgroundAttachment(), StyleAttributes.Definition.BACKGROUND_ATTACHMENT);
    }

    @Override
    public String getBackgroundColor() {
        String value = super.getBackgroundColor();
        if (StringUtils.isEmpty(value)) {
            return StyleAttributes.Definition.BACKGROUND_COLOR.getDefaultComputedValue(this.getBrowserVersion());
        }
        return ComputedCSSStyleDeclaration.toRGBColor(value);
    }

    @Override
    public String getBackgroundImage() {
        return this.defaultIfEmpty(super.getBackgroundImage(), StyleAttributes.Definition.BACKGROUND_IMAGE);
    }

    @Override
    public String getBackgroundPosition() {
        return this.defaultIfEmpty(super.getBackgroundPosition(), StyleAttributes.Definition.BACKGROUND_POSITION);
    }

    @Override
    public String getBackgroundRepeat() {
        return this.defaultIfEmpty(super.getBackgroundRepeat(), StyleAttributes.Definition.BACKGROUND_REPEAT);
    }

    @Override
    public String getBorderBottomColor() {
        return this.defaultIfEmpty(super.getBorderBottomColor(), StyleAttributes.Definition.BORDER_BOTTOM_COLOR);
    }

    @Override
    public String getBorderBottomStyle() {
        return this.defaultIfEmpty(super.getBorderBottomStyle(), StyleAttributes.Definition.BORDER_BOTTOM_STYLE);
    }

    @Override
    public String getBorderBottomWidth() {
        return ComputedCSSStyleDeclaration.pixelString(this.defaultIfEmpty(super.getBorderBottomWidth(), StyleAttributes.Definition.BORDER_BOTTOM_WIDTH));
    }

    @Override
    public String getBorderLeftColor() {
        return this.defaultIfEmpty(super.getBorderLeftColor(), StyleAttributes.Definition.BORDER_LEFT_COLOR);
    }

    @Override
    public String getBorderLeftStyle() {
        return this.defaultIfEmpty(super.getBorderLeftStyle(), StyleAttributes.Definition.BORDER_LEFT_STYLE);
    }

    @Override
    public String getBorderLeftWidth() {
        return ComputedCSSStyleDeclaration.pixelString(this.defaultIfEmpty(super.getBorderLeftWidth(), "0px", null));
    }

    @Override
    public String getBorderRightColor() {
        return this.defaultIfEmpty(super.getBorderRightColor(), "rgb(0, 0, 0)", null);
    }

    @Override
    public String getBorderRightStyle() {
        return this.defaultIfEmpty(super.getBorderRightStyle(), "none", null);
    }

    @Override
    public String getBorderRightWidth() {
        return ComputedCSSStyleDeclaration.pixelString(this.defaultIfEmpty(super.getBorderRightWidth(), "0px", null));
    }

    @Override
    public String getBorderTopColor() {
        return this.defaultIfEmpty(super.getBorderTopColor(), "rgb(0, 0, 0)", null);
    }

    @Override
    public String getBorderTopStyle() {
        return this.defaultIfEmpty(super.getBorderTopStyle(), "none", null);
    }

    @Override
    public String getBorderTopWidth() {
        return ComputedCSSStyleDeclaration.pixelString(this.defaultIfEmpty(super.getBorderTopWidth(), "0px", null));
    }

    @Override
    public String getBottom() {
        return this.defaultIfEmpty(super.getBottom(), "auto", null);
    }

    @Override
    public String getColor() {
        String value = this.defaultIfEmpty(super.getColor(), "rgb(0, 0, 0)", null);
        return ComputedCSSStyleDeclaration.toRGBColor(value);
    }

    @Override
    public String getCssFloat() {
        return this.defaultIfEmpty(super.getCssFloat(), StyleAttributes.Definition.CSS_FLOAT);
    }

    @Override
    public String getDisplay() {
        return this.getCssStyleDeclaration().getDisplay();
    }

    @Override
    public String getFont() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_STYLE_PROP_FONT_DISCONNECTED_IS_EMPTY) && this.getDomElement().isAttachedToPage()) {
            return super.getFont();
        }
        return "";
    }

    @Override
    public String getFontSize() {
        String value = super.getFontSize();
        if (!value.isEmpty()) {
            value = CssPixelValueConverter.pixelValue(value) + "px";
        }
        return value;
    }

    @Override
    public String getLineHeight() {
        return this.defaultIfEmpty(super.getLineHeight(), StyleAttributes.Definition.LINE_HEIGHT);
    }

    @Override
    public String getFontFamily() {
        return this.defaultIfEmpty(super.getFontFamily(), StyleAttributes.Definition.FONT_FAMILY);
    }

    @Override
    public String getHeight() {
        if ("none".equals(this.getDisplay())) {
            return "auto";
        }
        final Element elem = this.getElement();
        if (!elem.getDomNodeOrDie().isAttachedToPage()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_STYLE_PROP_DISCONNECTED_IS_EMPTY)) {
                return "";
            }
            if (this.getStyleAttribute(StyleAttributes.Definition.HEIGHT, true).isEmpty()) {
                return "auto";
            }
        }
        int windowHeight = elem.getWindow().getWebWindow().getInnerHeight();
        return CssPixelValueConverter.pixelString(elem.getDomNodeOrDie(), new CssPixelValueConverter.CssValue(0, windowHeight){

            @Override
            public String get(ComputedCssStyleDeclaration style) {
                String offsetHeight = ((HTMLElement)elem).getOffsetHeight() + "px";
                return ComputedCSSStyleDeclaration.this.defaultIfEmpty(style.getStyleAttribute(StyleAttributes.Definition.HEIGHT, true), offsetHeight, "auto");
            }
        });
    }

    @Override
    public String getLeft() {
        String superLeft = super.getLeft();
        if (!superLeft.endsWith("%")) {
            return this.defaultIfEmpty(superLeft, "auto", null);
        }
        final DomElement element = this.getDomElement();
        return CssPixelValueConverter.pixelString(element, new CssPixelValueConverter.CssValue(0, 0){

            @Override
            public String get(ComputedCssStyleDeclaration style) {
                if (style.getDomElementOrNull() == element) {
                    return style.getStyleAttribute(StyleAttributes.Definition.LEFT, true);
                }
                return style.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
            }
        });
    }

    @Override
    public String getLetterSpacing() {
        return this.defaultIfEmpty(super.getLetterSpacing(), "normal", null);
    }

    @Override
    public String getMargin() {
        return this.defaultIfEmpty(super.getMargin(), StyleAttributes.Definition.MARGIN, true);
    }

    @Override
    public String getMarginBottom() {
        return ComputedCSSStyleDeclaration.pixelString(this.defaultIfEmpty(super.getMarginBottom(), "0px", null));
    }

    @Override
    public String getMarginLeft() {
        return this.getMarginX(super.getMarginLeft(), StyleAttributes.Definition.MARGIN_LEFT);
    }

    @Override
    public String getMarginRight() {
        return this.getMarginX(super.getMarginRight(), StyleAttributes.Definition.MARGIN_RIGHT);
    }

    private String getMarginX(String superMarginX, final StyleAttributes.Definition definition) {
        if (!superMarginX.endsWith("%")) {
            return ComputedCSSStyleDeclaration.pixelString(this.defaultIfEmpty(superMarginX, "0px", null));
        }
        final DomElement element = this.getDomElement();
        if (!element.isAttachedToPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_STYLE_PROP_DISCONNECTED_IS_EMPTY)) {
            return "";
        }
        int windowWidth = element.getPage().getEnclosingWindow().getInnerWidth();
        return CssPixelValueConverter.pixelString(element, new CssPixelValueConverter.CssValue(0, windowWidth){

            @Override
            public String get(ComputedCssStyleDeclaration style) {
                if (style.getDomElementOrNull() == element) {
                    return style.getStyleAttribute(definition, true);
                }
                return style.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
            }
        });
    }

    @Override
    public String getMarginTop() {
        return ComputedCSSStyleDeclaration.pixelString(this.defaultIfEmpty(super.getMarginTop(), "0px", null));
    }

    @Override
    public String getMaxHeight() {
        return this.defaultIfEmpty(super.getMaxHeight(), "none", null);
    }

    @Override
    public String getMaxWidth() {
        return this.defaultIfEmpty(super.getMaxWidth(), "none", null);
    }

    @Override
    public String getMinHeight() {
        return this.defaultIfEmpty(super.getMinHeight(), "0px", null);
    }

    @Override
    public String getMinWidth() {
        return this.defaultIfEmpty(super.getMinWidth(), "0px", null);
    }

    @Override
    public String getOpacity() {
        return this.defaultIfEmpty(super.getOpacity(), "1", null);
    }

    @Override
    public String getOutlineWidth() {
        return this.defaultIfEmpty(super.getOutlineWidth(), "0px", null);
    }

    @Override
    public String getPadding() {
        return this.defaultIfEmpty(super.getPadding(), StyleAttributes.Definition.PADDING, true);
    }

    @Override
    public String getPaddingBottom() {
        return ComputedCSSStyleDeclaration.pixelString(this.defaultIfEmpty(super.getPaddingBottom(), "0px", null));
    }

    @Override
    public String getPaddingLeft() {
        return ComputedCSSStyleDeclaration.pixelString(this.defaultIfEmpty(super.getPaddingLeft(), "0px", null));
    }

    @Override
    public String getPaddingRight() {
        return ComputedCSSStyleDeclaration.pixelString(this.defaultIfEmpty(super.getPaddingRight(), "0px", null));
    }

    @Override
    public String getPaddingTop() {
        return ComputedCSSStyleDeclaration.pixelString(this.defaultIfEmpty(super.getPaddingTop(), "0px", null));
    }

    @Override
    public String getRight() {
        return this.defaultIfEmpty(super.getRight(), "auto", null);
    }

    @Override
    public String getTextIndent() {
        return this.defaultIfEmpty(super.getTextIndent(), "0px", null);
    }

    @Override
    public String getTop() {
        final DomElement element = this.getDomElement();
        if (!element.isAttachedToPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_STYLE_PROP_DISCONNECTED_IS_EMPTY)) {
            return "";
        }
        String superTop = super.getTop();
        if (!superTop.endsWith("%")) {
            return this.defaultIfEmpty(superTop, StyleAttributes.Definition.TOP);
        }
        return CssPixelValueConverter.pixelString(element, new CssPixelValueConverter.CssValue(0, 0){

            @Override
            public String get(ComputedCssStyleDeclaration style) {
                if (style.getDomElementOrNull() == element) {
                    return style.getStyleAttribute(StyleAttributes.Definition.TOP, true);
                }
                return style.getStyleAttribute(StyleAttributes.Definition.HEIGHT, true);
            }
        });
    }

    @Override
    public String getVerticalAlign() {
        return this.defaultIfEmpty(super.getVerticalAlign(), "baseline", null);
    }

    @Override
    public String getWidows() {
        return this.defaultIfEmpty(super.getWidows(), StyleAttributes.Definition.WIDOWS);
    }

    @Override
    public String getOrphans() {
        return this.defaultIfEmpty(super.getOrphans(), StyleAttributes.Definition.ORPHANS);
    }

    @Override
    public String getPosition() {
        return this.defaultIfEmpty(super.getPosition(), StyleAttributes.Definition.POSITION);
    }

    @Override
    public String getWidth() {
        return this.getCssStyleDeclaration().getWidth();
    }

    public int getCalculatedWidth(boolean includeBorder, boolean includePadding) {
        DomElement element = this.getDomElement();
        if (!element.isAttachedToPage()) {
            return 0;
        }
        int width = this.getCalculatedWidth();
        if (!"border-box".equals(this.getStyleAttribute(StyleAttributes.Definition.BOX_SIZING))) {
            if (includeBorder) {
                width += this.getBorderHorizontal();
            } else if (this.isScrollable(true, true) && !(element instanceof HtmlBody)) {
                width -= 17;
            }
            if (includePadding) {
                width += this.getPaddingHorizontal();
            }
        }
        return width;
    }

    private int getCalculatedWidth() {
        int width;
        Integer cachedWidth = this.getCssStyleDeclaration().getCachedWidth();
        if (cachedWidth != null) {
            return cachedWidth;
        }
        DomElement element = this.getDomElement();
        if (!element.mayBeDisplayed()) {
            return this.getCssStyleDeclaration().setCachedWidth(0);
        }
        String display = this.getDisplay();
        if ("none".equals(display)) {
            return this.getCssStyleDeclaration().setCachedWidth(0);
        }
        String styleWidth = super.getWidth();
        DomNode parent = element.getParentNode();
        if (("inline".equals(display) || StringUtils.isEmpty(styleWidth)) && parent instanceof HtmlElement) {
            if (element instanceof HtmlCanvas) {
                return 300;
            }
            String cssFloat = this.getCssFloat();
            String position = this.getStyleAttribute(StyleAttributes.Definition.POSITION, true);
            if ("right".equals(cssFloat) || "left".equals(cssFloat) || "absolute".equals(position) || "fixed".equals(position)) {
                width = element.getVisibleText().length() * this.getBrowserVersion().getPixesPerChar();
            } else if ("block".equals(display)) {
                int windowWidth = element.getPage().getEnclosingWindow().getInnerWidth();
                if (element instanceof HtmlBody) {
                    width = windowWidth - 16;
                } else {
                    HTMLElement parentJS = (HTMLElement)parent.getScriptableObject();
                    width = CssPixelValueConverter.pixelValue(parentJS.getDomNodeOrDie(), new CssPixelValueConverter.CssValue(0, windowWidth){

                        @Override
                        public String get(ComputedCssStyleDeclaration style) {
                            return style.getWidth();
                        }
                    }) - (this.getBorderHorizontal() + this.getPaddingHorizontal());
                }
            } else if (element instanceof HtmlSubmitInput || element instanceof HtmlResetInput || element instanceof HtmlButtonInput || element instanceof HtmlButton || element instanceof HtmlFileInput) {
                String text = element.asNormalizedText();
                width = 10 + (int)((double)(text.length() * this.getBrowserVersion().getPixesPerChar()) * 0.9);
            } else if (element instanceof HtmlTextInput || element instanceof HtmlPasswordInput) {
                BrowserVersion browserVersion = this.getBrowserVersion();
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_CLIENTWIDTH_INPUT_TEXT_143)) {
                    return 143;
                }
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_CLIENTWIDTH_INPUT_TEXT_173)) {
                    return 173;
                }
                width = 145;
            } else {
                BrowserVersion browserVersion;
                width = element instanceof HtmlRadioButtonInput || element instanceof HtmlCheckBoxInput ? ((browserVersion = this.getBrowserVersion()).hasFeature(BrowserVersionFeatures.JS_CLIENTWIDTH_RADIO_CHECKBOX_10) ? 10 : 13) : (element instanceof HtmlTextArea ? 100 : (element instanceof HtmlImage ? ((HtmlImage)element).getWidthOrDefault() : this.getContentWidth()));
            }
        } else {
            width = "auto".equals(styleWidth) ? element.getPage().getEnclosingWindow().getInnerWidth() : CssPixelValueConverter.pixelValue(element, new CssPixelValueConverter.CssValue(0, element.getPage().getEnclosingWindow().getInnerWidth()){

                @Override
                public String get(ComputedCssStyleDeclaration style) {
                    return style.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
                }
            });
        }
        return this.getCssStyleDeclaration().setCachedWidth(width);
    }

    public int getContentWidth() {
        Page enclosedPage;
        int width = 0;
        DomElement element = this.getDomElement();
        Iterable<DomNode> children = element.getChildren();
        if (element instanceof BaseFrameElement && (enclosedPage = ((BaseFrameElement)element).getEnclosedPage()) != null && enclosedPage.isHtmlPage()) {
            children = ((DomNode)((Object)enclosedPage)).getChildren();
        }
        for (DomNode child : children) {
            if (child.getScriptableObject() instanceof HTMLElement) {
                HTMLElement e = (HTMLElement)child.getScriptableObject();
                ComputedCSSStyleDeclaration style = e.getWindow().getComputedStyle(e, null);
                int w = style.getCalculatedWidth(true, true);
                width += w;
                continue;
            }
            if (!(child.getScriptableObject() instanceof Text)) continue;
            DomNode parent = child.getParentNode();
            if (parent instanceof HtmlElement) {
                HTMLElement e = (HTMLElement)child.getParentNode().getScriptableObject();
                ComputedCSSStyleDeclaration style = e.getWindow().getComputedStyle(e, null);
                int height = this.getBrowserVersion().getFontHeight(style.getFontSize());
                width += child.getVisibleText().length() * (int)((float)height / 1.8f);
                continue;
            }
            width += child.getVisibleText().length() * this.getBrowserVersion().getPixesPerChar();
        }
        return width;
    }

    public int getCalculatedHeight(boolean includeBorder, boolean includePadding) {
        DomElement element = this.getDomElement();
        if (!element.isAttachedToPage()) {
            return 0;
        }
        int height = this.getCalculatedHeight();
        if (!"border-box".equals(this.getStyleAttribute(StyleAttributes.Definition.BOX_SIZING))) {
            if (includeBorder) {
                height += this.getBorderVertical();
            } else if (this.isScrollable(false, true) && !(element instanceof HtmlBody)) {
                height -= 17;
            }
            if (includePadding) {
                height += this.getPaddingVertical();
            }
        }
        return height;
    }

    private int getCalculatedHeight() {
        int contentHeight;
        boolean isInline;
        Integer cachedHeight = this.getCssStyleDeclaration().getCachedHeight();
        if (cachedHeight != null) {
            return cachedHeight;
        }
        DomElement element = this.getDomElement();
        if (element instanceof HtmlImage) {
            return this.getCssStyleDeclaration().setCachedHeight(((HtmlImage)element).getHeightOrDefault());
        }
        boolean bl = isInline = "inline".equals(this.getDisplay()) && !(element instanceof HtmlInlineFrame);
        if ((isInline || super.getHeight().isEmpty()) && (contentHeight = this.getContentHeight()) > 0) {
            return this.getCssStyleDeclaration().setCachedHeight(contentHeight);
        }
        return this.getCssStyleDeclaration().setCachedHeight(this.getEmptyHeight());
    }

    private int getEmptyHeight() {
        int defaultHeight;
        boolean explicitHeightSpecified;
        Integer cachedHeight2 = this.getCssStyleDeclaration().getCachedHeight2();
        if (cachedHeight2 != null) {
            return cachedHeight2;
        }
        DomElement element = this.getDomElement();
        if (!element.mayBeDisplayed()) {
            return this.getCssStyleDeclaration().setCachedHeight2(0);
        }
        String display = this.getDisplay();
        if ("none".equals(display)) {
            return this.getCssStyleDeclaration().setCachedHeight2(0);
        }
        WebWindow webWindow = element.getPage().getEnclosingWindow();
        int windowHeight = webWindow.getInnerHeight();
        if (element instanceof HtmlBody) {
            return this.getCssStyleDeclaration().setCachedHeight2(windowHeight);
        }
        final boolean isInline = "inline".equals(display) && !(element instanceof HtmlInlineFrame);
        boolean bl = explicitHeightSpecified = !isInline && !super.getHeight().isEmpty();
        if ((element.getScriptableObject().getClass() == HTMLElement.class || element instanceof HtmlDivision || element instanceof HtmlUnknownElement || element instanceof HtmlData || element instanceof HtmlTime || element instanceof HtmlOutput || element instanceof HtmlSlot || element instanceof HtmlLegend) && StringUtils.isBlank(element.getTextContent())) {
            defaultHeight = 0;
        } else if (element.getFirstChild() == null) {
            BrowserVersion browser;
            defaultHeight = element instanceof HtmlRadioButtonInput || element instanceof HtmlCheckBoxInput ? (webWindow.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLIENTHEIGHT_RADIO_CHECKBOX_10) ? 10 : 13) : (element instanceof HtmlButton ? 20 : (element instanceof HtmlInput && !(element instanceof HtmlHiddenInput) ? ((browser = webWindow.getWebClient().getBrowserVersion()).hasFeature(BrowserVersionFeatures.JS_CLIENTHEIGHT_INPUT_17) ? 17 : (browser.hasFeature(BrowserVersionFeatures.JS_CLIENTHEIGHT_INPUT_18) ? 18 : 20)) : (element instanceof HtmlSelect ? 20 : (element instanceof HtmlTextArea ? 49 : (element instanceof HtmlInlineFrame ? 154 : 0)))));
        } else {
            String fontSize = this.getFontSize();
            defaultHeight = webWindow.getWebClient().getBrowserVersion().getFontHeight(fontSize);
            if (element instanceof HtmlDivision || element instanceof HtmlSpan) {
                String width = this.getStyleAttribute(StyleAttributes.Definition.WIDTH, false);
                for (Element parent = this.getElement().getParentElement(); width.isEmpty() && parent != null; parent = parent.getParentElement()) {
                    width = this.getWindow().getComputedStyle(parent, null).getStyleAttribute(StyleAttributes.Definition.WIDTH, false);
                }
                int pixelWidth = CssPixelValueConverter.pixelValue(width);
                String content = element.getVisibleText();
                if (pixelWidth > 0 && !width.isEmpty() && StringUtils.isNotBlank(content)) {
                    String[] lines = StringUtils.split(content, '\n');
                    int lineCount = 0;
                    int fontSizeInt = Integer.parseInt(fontSize.substring(0, fontSize.length() - 2));
                    FontRenderContext fontRenderCtx = new FontRenderContext(null, false, true);
                    for (String line : lines) {
                        if (StringUtils.isBlank(line)) {
                            ++lineCount;
                            continue;
                        }
                        AttributedString attributedString = new AttributedString(line);
                        attributedString.addAttribute(TextAttribute.SIZE, (double)fontSizeInt / 1.1);
                        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderCtx);
                        lineBreakMeasurer.nextLayout(pixelWidth);
                        ++lineCount;
                        while (lineBreakMeasurer.getPosition() < line.length() && lineCount < 1000) {
                            lineBreakMeasurer.nextLayout(pixelWidth);
                            ++lineCount;
                        }
                    }
                    defaultHeight *= lineCount;
                } else {
                    defaultHeight = element instanceof HtmlSpan && StringUtils.isEmpty(content) ? 0 : (defaultHeight *= StringUtils.countMatches((CharSequence)content, '\n') + 1);
                }
            }
        }
        int defaultWindowHeight = element instanceof HtmlCanvas ? 150 : windowHeight;
        int height = CssPixelValueConverter.pixelValue(element, new CssPixelValueConverter.CssValue(defaultHeight, defaultWindowHeight){

            @Override
            public String get(ComputedCssStyleDeclaration style) {
                Element element = style.getElementOrNull();
                if (element instanceof HTMLBodyElement) {
                    return String.valueOf(element.getWindow().getWebWindow().getInnerHeight());
                }
                if (isInline) {
                    return "";
                }
                return style.getStyleAttribute(StyleAttributes.Definition.HEIGHT, true);
            }
        });
        if (height == 0 && !explicitHeightSpecified) {
            height = defaultHeight;
        }
        return this.getCssStyleDeclaration().setCachedHeight2(height);
    }

    public int getContentHeight() {
        DomElement node = this.getDomElement();
        if (!node.mayBeDisplayed()) {
            return 0;
        }
        ComputedCSSStyleDeclaration lastFlowing = null;
        HashSet<ComputedCSSStyleDeclaration> styles = new HashSet<ComputedCSSStyleDeclaration>();
        for (DomNode child : node.getChildren()) {
            Object scriptObj;
            if (!child.mayBeDisplayed() || !((scriptObj = child.getScriptableObject()) instanceof HTMLElement)) continue;
            HTMLElement e = (HTMLElement)scriptObj;
            ComputedCSSStyleDeclaration style = e.getWindow().getComputedStyle(e, null);
            String position = style.getPositionWithInheritance();
            if ("static".equals(position) || "relative".equals(position)) {
                lastFlowing = style;
                continue;
            }
            if (!"absolute".equals(position) && !"fixed".equals(position)) continue;
            styles.add(style);
        }
        if (lastFlowing != null) {
            styles.add(lastFlowing);
        }
        int max = 0;
        for (ComputedCSSStyleDeclaration style : styles) {
            int h = style.getTop(true, false, false) + style.getCalculatedHeight(true, true);
            if (h <= max) continue;
            max = h;
        }
        return max;
    }

    public boolean isScrollable(boolean horizontal) {
        return this.isScrollable(horizontal, false);
    }

    private boolean isScrollable(boolean horizontal, boolean ignoreSize) {
        DomElement element = this.getDomElement();
        String overflow = this.getStyleAttribute(StyleAttributes.Definition.OVERFLOW, true);
        boolean scrollable = horizontal ? !(!(element instanceof HtmlBody) && !"scroll".equals(overflow) && !"auto".equals(overflow) || !ignoreSize && this.getContentWidth() <= this.getCalculatedWidth()) : !(!(element instanceof HtmlBody) && !"scroll".equals(overflow) && !"auto".equals(overflow) || !ignoreSize && this.getContentHeight() <= this.getEmptyHeight());
        return scrollable;
    }

    public int getTop(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        Integer cachedTop = this.getCssStyleDeclaration().getCachedTop();
        int top = 0;
        if (null == cachedTop) {
            String position = this.getPositionWithInheritance();
            if ("absolute".equals(position) || "fixed".equals(position)) {
                top = this.getTopForAbsolutePositionWithInheritance();
            } else {
                boolean prevHadComputedTop = false;
                for (DomNode prev = this.getDomElement().getPreviousSibling(); prev != null && !prevHadComputedTop; prev = prev.getPreviousSibling()) {
                    Element e;
                    ComputedCSSStyleDeclaration style;
                    String display;
                    if (!(prev instanceof HtmlElement) || !ComputedCSSStyleDeclaration.isBlock(display = (style = (e = (Element)prev.getScriptableObject()).getWindow().getComputedStyle(e, null)).getDisplay())) continue;
                    int prevTop = 0;
                    Integer eCachedTop = style.getCssStyleDeclaration().getCachedTop();
                    if (eCachedTop == null) {
                        String prevPosition = style.getPositionWithInheritance();
                        if ("absolute".equals(prevPosition) || "fixed".equals(prevPosition)) {
                            prevTop += style.getTopForAbsolutePositionWithInheritance();
                        } else if ("relative".equals(prevPosition)) {
                            String t = style.getTopWithInheritance();
                            prevTop += CssPixelValueConverter.pixelValue(t);
                        }
                    } else {
                        prevHadComputedTop = true;
                        prevTop += eCachedTop.intValue();
                    }
                    prevTop += style.getCalculatedHeight(true, true);
                    int margin = CssPixelValueConverter.pixelValue(style.getMarginTop());
                    top += (prevTop += margin);
                }
                if ("relative".equals(position)) {
                    String t = this.getTopWithInheritance();
                    top += CssPixelValueConverter.pixelValue(t);
                }
            }
            cachedTop = top;
            this.getCssStyleDeclaration().setCachedTop(cachedTop);
        } else {
            top = cachedTop;
        }
        if (includeMargin) {
            int margin = CssPixelValueConverter.pixelValue(this.getMarginTop());
            top += margin;
        }
        if (includeBorder) {
            int border = CssPixelValueConverter.pixelValue(this.getBorderTopWidth());
            top += border;
        }
        if (includePadding) {
            int padding = this.getPaddingTopValue();
            top += padding;
        }
        return top;
    }

    private static boolean isBlock(String display) {
        return display != null && !"inline".equals(display) && !"none".equals(display);
    }

    private int getTopForAbsolutePositionWithInheritance() {
        String t = this.getTopWithInheritance();
        if (!"auto".equals(t)) {
            return CssPixelValueConverter.pixelValue(t);
        }
        String b = this.getBottomWithInheritance();
        if (!"auto".equals(b)) {
            int top = 0;
            for (DomNode child = this.getDomElement().getParentNode().getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof HtmlElement) || !child.mayBeDisplayed()) continue;
                top += 20;
            }
            return top -= CssPixelValueConverter.pixelValue(b);
        }
        return 0;
    }

    public int getLeft(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        HTMLElement parent;
        int left;
        String p = this.getPositionWithInheritance();
        String l = this.getLeftWithInheritance();
        String r = this.getRightWithInheritance();
        if (("absolute".equals(p) || "fixed".equals(p)) && !"auto".equals(l)) {
            left = CssPixelValueConverter.pixelValue(l);
        } else if (("absolute".equals(p) || "fixed".equals(p)) && !"auto".equals(r)) {
            int parentWidth;
            parent = (HTMLElement)this.getElement().getParentElement();
            if (parent == null) {
                parentWidth = this.getWindow().getInnerWidth();
            } else {
                ComputedCSSStyleDeclaration parentStyle = parent.getWindow().getComputedStyle(parent, null);
                parentWidth = parentStyle.getCalculatedWidth(false, false);
            }
            left = parentWidth - CssPixelValueConverter.pixelValue(r);
        } else if ("fixed".equals(p) && !"auto".equals(r)) {
            int parentWidth;
            ComputedCSSStyleDeclaration style = this.getWindow().getComputedStyle(this.getElement(), null);
            HTMLElement parent2 = (HTMLElement)this.getElement().getParentElement();
            if (parent2 == null) {
                parentWidth = this.getWindow().getInnerWidth();
            } else {
                ComputedCSSStyleDeclaration parentStyle = parent2.getWindow().getComputedStyle(parent2, null);
                parentWidth = CssPixelValueConverter.pixelValue(parentStyle.getWidth()) - CssPixelValueConverter.pixelValue(style.getWidth());
            }
            left = parentWidth - CssPixelValueConverter.pixelValue(r);
        } else if ("fixed".equals(p) && "auto".equals(l)) {
            parent = (HTMLElement)this.getElement().getParentElement();
            if (parent == null) {
                left = 0;
            } else {
                ComputedCSSStyleDeclaration style = parent.getWindow().getComputedStyle(parent, null);
                left = CssPixelValueConverter.pixelValue(style.getLeftWithInheritance());
            }
        } else if ("static".equals(p)) {
            left = 0;
            for (DomNode prev = this.getDomElement().getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
                String content;
                Scriptable prevScriptable = (Scriptable)prev.getScriptableObject();
                if (prevScriptable instanceof HTMLElement) {
                    HTMLElement e = (HTMLElement)prevScriptable;
                    ComputedCSSStyleDeclaration style = e.getWindow().getComputedStyle(e, null);
                    String d = style.getDisplay();
                    if (!ComputedCSSStyleDeclaration.isBlock(d)) {
                        if ("none".equals(d)) continue;
                        left += style.getCalculatedWidth(true, true);
                        continue;
                    }
                    break;
                }
                if (!(prevScriptable instanceof Text) || (content = prev.getVisibleText()) == null) continue;
                left += content.trim().length() * this.getBrowserVersion().getPixesPerChar();
            }
        } else {
            left = CssPixelValueConverter.pixelValue(l);
        }
        if (includeMargin) {
            int margin = this.getMarginLeftValue();
            left += margin;
        }
        if (includeBorder) {
            int border = CssPixelValueConverter.pixelValue(this.getBorderLeftWidth());
            left += border;
        }
        if (includePadding) {
            int padding = this.getPaddingLeftValue();
            left += padding;
        }
        return left;
    }

    public String getPositionWithInheritance() {
        String p = this.getStyleAttribute(StyleAttributes.Definition.POSITION, true);
        if ("inherit".equals(p)) {
            HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
            if (parent == null) {
                p = "static";
            } else {
                ComputedCSSStyleDeclaration style = parent.getWindow().getComputedStyle(parent, null);
                p = style.getPositionWithInheritance();
            }
        }
        return p;
    }

    public String getLeftWithInheritance() {
        String left = this.getLeft();
        if ("inherit".equals(left)) {
            HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
            if (parent == null) {
                left = "auto";
            } else {
                ComputedCSSStyleDeclaration style = parent.getWindow().getComputedStyle(parent, null);
                left = style.getLeftWithInheritance();
            }
        }
        return left;
    }

    public String getRightWithInheritance() {
        String right = this.getRight();
        if ("inherit".equals(right)) {
            HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
            if (parent == null) {
                right = "auto";
            } else {
                ComputedCSSStyleDeclaration style = parent.getWindow().getComputedStyle(parent, null);
                right = style.getRightWithInheritance();
            }
        }
        return right;
    }

    public String getTopWithInheritance() {
        String top = this.getTop();
        if ("inherit".equals(top)) {
            HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
            if (parent == null) {
                top = "auto";
            } else {
                ComputedCSSStyleDeclaration style = parent.getWindow().getComputedStyle(parent, null);
                top = style.getTopWithInheritance();
            }
        }
        return top;
    }

    public String getBottomWithInheritance() {
        String bottom = this.getBottom();
        if ("inherit".equals(bottom)) {
            HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
            if (parent == null) {
                bottom = "auto";
            } else {
                ComputedCSSStyleDeclaration style = parent.getWindow().getComputedStyle(parent, null);
                bottom = style.getBottomWithInheritance();
            }
        }
        return bottom;
    }

    public int getMarginLeftValue() {
        return CssPixelValueConverter.pixelValue(this.getMarginLeft());
    }

    public int getMarginRightValue() {
        return CssPixelValueConverter.pixelValue(this.getMarginRight());
    }

    public int getMarginTopValue() {
        return CssPixelValueConverter.pixelValue(this.getMarginTop());
    }

    public int getMarginBottomValue() {
        return CssPixelValueConverter.pixelValue(this.getMarginBottom());
    }

    public int getPaddingLeftValue() {
        return CssPixelValueConverter.pixelValue(this.getPaddingLeft());
    }

    public int getPaddingRightValue() {
        return CssPixelValueConverter.pixelValue(this.getPaddingRight());
    }

    public int getPaddingTopValue() {
        return CssPixelValueConverter.pixelValue(this.getPaddingTop());
    }

    public int getPaddingBottomValue() {
        return CssPixelValueConverter.pixelValue(this.getPaddingBottom());
    }

    private int getPaddingHorizontal() {
        Integer paddingHorizontal = this.getCssStyleDeclaration().getCachedPaddingHorizontal();
        if (paddingHorizontal != null) {
            return paddingHorizontal;
        }
        int padding = "none".equals(this.getDisplay()) ? 0 : this.getPaddingLeftValue() + this.getPaddingRightValue();
        return this.getCssStyleDeclaration().setCachedPaddingHorizontal(padding);
    }

    private int getPaddingVertical() {
        Integer paddingVertical = this.getCssStyleDeclaration().getCachedPaddingVertical();
        if (paddingVertical != null) {
            return paddingVertical;
        }
        int padding = "none".equals(this.getDisplay()) ? 0 : this.getPaddingTopValue() + this.getPaddingBottomValue();
        return this.getCssStyleDeclaration().setCachedPaddingVertical(padding);
    }

    public int getBorderLeftValue() {
        return CssPixelValueConverter.pixelValue(this.getBorderLeftWidth());
    }

    public int getBorderRightValue() {
        return CssPixelValueConverter.pixelValue(this.getBorderRightWidth());
    }

    public int getBorderTopValue() {
        return CssPixelValueConverter.pixelValue(this.getBorderTopWidth());
    }

    public int getBorderBottomValue() {
        return CssPixelValueConverter.pixelValue(this.getBorderBottomWidth());
    }

    private int getBorderHorizontal() {
        Integer borderHorizontal = this.getCssStyleDeclaration().getCachedBorderHorizontal();
        if (borderHorizontal != null) {
            return borderHorizontal;
        }
        int border = "none".equals(this.getDisplay()) ? 0 : this.getBorderLeftValue() + this.getBorderRightValue();
        return this.getCssStyleDeclaration().setCachedBorderHorizontal(border);
    }

    private int getBorderVertical() {
        Integer borderVertical = this.getCssStyleDeclaration().getCachedBorderVertical();
        if (borderVertical != null) {
            return borderVertical;
        }
        int border = "none".equals(this.getDisplay()) ? 0 : this.getBorderTopValue() + this.getBorderBottomValue();
        return this.getCssStyleDeclaration().setCachedBorderVertical(border);
    }

    @Override
    public String getWordSpacing() {
        return this.defaultIfEmpty(super.getWordSpacing(), StyleAttributes.Definition.WORD_SPACING);
    }

    @Override
    public Object getZIndex() {
        Object response = super.getZIndex();
        if (response.toString().isEmpty()) {
            return "auto";
        }
        return response;
    }

    @Override
    public String getPropertyValue(String name) {
        Object property = ComputedCSSStyleDeclaration.getProperty((Scriptable)this, com.gargoylesoftware.htmlunit.util.StringUtils.cssCamelize(name));
        if (property == NOT_FOUND) {
            return super.getPropertyValue(name);
        }
        return Context.toString(property);
    }

    private static String pixelString(String value) {
        if (ComputedCssStyleDeclaration.EMPTY_FINAL == value || value.endsWith("px")) {
            return value;
        }
        return CssPixelValueConverter.pixelValue(value) + "px";
    }
}

