/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.sourceforge.htmlunit.corejs.javascript.Callable;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class HTMLCollection
extends AbstractList
implements Callable {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLCollection() {
    }

    public HTMLCollection(DomNode domNode, boolean attributeChangeSensitive) {
        super(domNode, attributeChangeSensitive, null);
    }

    HTMLCollection(DomNode domNode, List<DomNode> initialElements) {
        super(domNode, true, new ArrayList<DomNode>(initialElements));
    }

    private HTMLCollection(DomNode domNode, boolean attributeChangeSensitive, List<DomNode> initialElements) {
        super(domNode, attributeChangeSensitive, new ArrayList<DomNode>(initialElements));
    }

    public static HTMLCollection emptyCollection(DomNode domNode) {
        return new HTMLCollection(domNode, false, Collections.emptyList());
    }

    @Override
    protected HTMLCollection create(DomNode parentScope, List<DomNode> initialElements) {
        return new HTMLCollection(parentScope, initialElements);
    }

    @Override
    @JsxGetter
    public final int getLength() {
        return super.getLength();
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (this.supportsParentheses()) {
            if (args.length == 0) {
                throw Context.reportRuntimeError("Zero arguments; need an index or a key.");
            }
            Object object = this.getIt(args[0]);
            if (object == NOT_FOUND) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_NULL_IF_NOT_FOUND)) {
                    return null;
                }
                return Undefined.instance;
            }
            return object;
        }
        throw ScriptRuntime.typeError("HTMLCollection does nont support function like access");
    }

    protected boolean supportsParentheses() {
        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_SUPPORTS_PARANTHESES);
    }

    @Override
    protected Object getWithPreemptionByName(String name, List<DomNode> elements) {
        ArrayList<DomNode> matchingElements = new ArrayList<DomNode>();
        boolean searchName = this.isGetWithPreemptionSearchName();
        for (DomNode next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !searchName && !(next instanceof HtmlInput) && !(next instanceof HtmlForm) || !name.equals(nodeName = ((DomElement)next).getAttributeDirect("name"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            double doubleValue;
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_ITEM_SUPPORTS_DOUBLE_INDEX_ALSO) && !Double.isNaN(doubleValue = Context.toNumber(name))) {
                return this.get((int)doubleValue, (Scriptable)this);
            }
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        DomNode domNode = this.getDomNodeOrNull();
        HTMLCollection collection = new HTMLCollection(domNode, matchingElements);
        collection.setAvoidObjectDetection(true);
        return collection;
    }

    protected boolean isGetWithPreemptionSearchName() {
        return true;
    }

    @JsxFunction
    public Object item(Object index) {
        Object object;
        if (index instanceof String && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_ITEM_SUPPORTS_ID_SEARCH_ALSO)) {
            String name = (String)index;
            return this.namedItem(name);
        }
        int idx = 0;
        double doubleValue = Context.toNumber(index);
        if (!Double.isNaN(doubleValue)) {
            idx = (int)doubleValue;
        }
        if ((object = this.get(idx, (Scriptable)this)) == NOT_FOUND) {
            return null;
        }
        return object;
    }

    @JsxFunction
    public Object namedItem(String name) {
        DomElement elem;
        List<DomNode> elements = this.getElements();
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_NAMED_ITEM_ID_FIRST)) {
            for (DomNode next : elements) {
                String id;
                if (!(next instanceof DomElement) || !name.equals(id = (elem = (DomElement)next).getId())) continue;
                return this.getScriptableForElement(elem);
            }
        }
        for (DomNode next : elements) {
            if (!(next instanceof DomElement)) continue;
            elem = (DomElement)next;
            String nodeName = elem.getAttributeDirect("name");
            if (name.equals(nodeName)) {
                return this.getScriptableForElement(elem);
            }
            String id = elem.getId();
            if (!name.equals(id)) continue;
            return this.getScriptableForElement(elem);
        }
        return null;
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public Object tags(String tagName) {
        HTMLCollection tags = new HTMLCollection(this.getDomNodeOrDie(), false);
        tags.setElementsSupplier((Supplier<List> & Serializable)() -> {
            ArrayList<DomNode> list = new ArrayList<DomNode>();
            for (DomNode elem : this.getElements()) {
                if (!tagName.equalsIgnoreCase(elem.getLocalName())) continue;
                list.add(elem);
            }
            return list;
        });
        return tags;
    }
}

