/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import hidden.jth.org.apache.commons.lang3.ArrayUtils;
import hidden.jth.org.apache.commons.lang3.StringUtils;
import hidden.jth.org.brotli.dec.BrotliInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.DownloadedContent;
import org.htmlunit.util.NameValuePair;

public class WebResponseData
implements Serializable {
    private static final Log LOG = LogFactory.getLog(WebResponseData.class);
    private final int statusCode_;
    private final String statusMessage_;
    private final List<NameValuePair> responseHeaders_;
    private final DownloadedContent downloadedContent_;

    public WebResponseData(byte[] body, int statusCode, String statusMessage, List<NameValuePair> responseHeaders) {
        this(new DownloadedContent.InMemory(body), statusCode, statusMessage, responseHeaders);
    }

    protected WebResponseData(int statusCode, String statusMessage, List<NameValuePair> responseHeaders) {
        this(ArrayUtils.EMPTY_BYTE_ARRAY, statusCode, statusMessage, responseHeaders);
    }

    public WebResponseData(DownloadedContent downloadedContent, int statusCode, String statusMessage, List<NameValuePair> responseHeaders) {
        this.statusCode_ = statusCode;
        this.statusMessage_ = statusMessage;
        this.responseHeaders_ = Collections.unmodifiableList(responseHeaders);
        this.downloadedContent_ = downloadedContent;
    }

    private InputStream getStream(ByteOrderMark ... bomHeaders) throws IOException {
        InputStream stream = this.downloadedContent_.getInputStream();
        if (this.downloadedContent_.isEmpty()) {
            return stream;
        }
        List<NameValuePair> headers = this.getResponseHeaders();
        String encoding = WebResponseData.getHeader(headers, "content-encoding");
        if (encoding != null) {
            boolean isGzip;
            boolean bl = isGzip = StringUtils.contains((CharSequence)encoding, "gzip") && !"no-gzip".equals(encoding);
            if ("gzip-only-text/html".equals(encoding)) {
                isGzip = "text/html".equals(WebResponseData.getHeader(headers, "content-type"));
            }
            if (isGzip) {
                try {
                    stream = new GZIPInputStream(stream);
                }
                catch (IOException e) {
                    LOG.error((Object)"Reading gzip encodec content failed.", (Throwable)e);
                    stream.close();
                    stream = IOUtils.toInputStream((String)"<!DOCTYPE html><html>\n<head><title>Problem loading page</title></head>\n<body>\n<h1>Content Encoding Error</h1>\n<p>The page you are trying to view cannot be shown because it uses an invalid or unsupported form of compression.</p>\n</body>\n</html>", (Charset)StandardCharsets.ISO_8859_1);
                }
                if (stream != null && bomHeaders != null) {
                    stream = new BOMInputStream(stream, bomHeaders);
                }
                return stream;
            }
            if ("br".equals(encoding)) {
                try {
                    stream = new BrotliInputStream(stream);
                }
                catch (IOException e) {
                    LOG.error((Object)"Reading Brotli encodec content failed.", (Throwable)e);
                    stream.close();
                    stream = IOUtils.toInputStream((String)"<!DOCTYPE html><html>\n<head><title>Problem loading page</title></head>\n<body>\n<h1>Content Encoding Error</h1>\n<p>The page you are trying to view cannot be shown because it uses an invalid or unsupported form of compression.</p>\n</body>\n</html>", (Charset)StandardCharsets.ISO_8859_1);
                }
                return stream;
            }
            if (StringUtils.contains((CharSequence)encoding, "deflate")) {
                boolean zlibHeader = false;
                if (stream.markSupported()) {
                    stream.mark(2);
                    byte[] buffer = new byte[2];
                    int byteCount = IOUtils.read((InputStream)stream, (byte[])buffer, (int)0, (int)2);
                    zlibHeader = byteCount == 2 && ((buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF) == 30876;
                    stream.reset();
                }
                stream = zlibHeader ? new InflaterInputStream(stream) : new InflaterInputStream(stream, new Inflater(true));
                return stream;
            }
        }
        if (stream != null && bomHeaders != null) {
            stream = new BOMInputStream(stream, bomHeaders);
        }
        return stream;
    }

    private static String getHeader(List<NameValuePair> headers, String name) {
        for (NameValuePair header : headers) {
            String headerName = header.getName().trim();
            if (!name.equalsIgnoreCase(headerName)) continue;
            return header.getValue();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBody() {
        try (InputStream is = this.getInputStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.getStream(null);
    }

    public InputStream getInputStreamWithBomIfApplicable(ByteOrderMark ... bomHeaders) throws IOException {
        return this.getStream(bomHeaders);
    }

    public List<NameValuePair> getResponseHeaders() {
        return this.responseHeaders_;
    }

    public int getStatusCode() {
        return this.statusCode_;
    }

    public String getStatusMessage() {
        return this.statusMessage_;
    }

    public long getContentLength() {
        return this.downloadedContent_.length();
    }

    public void cleanUp() {
        this.downloadedContent_.cleanUp();
    }
}

